/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.ReflectUtils;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static boolean isSuccess(String responseBody) {
        ObjectResponse<?> response = ResponseUtils.getObjectResponse(responseBody);
        return ObjectResponse.isSuccess(response);
    }

    public static ObjectResponse<?> getObjectResponse(String responseBody) {
        if (StringUtils.isBlank((CharSequence)responseBody)) {
            return null;
        }
        ObjectResponse response = null;
        try {
            response = (ObjectResponse)JSONObject.parseObject((String)responseBody, ObjectResponse.class);
            if (response == null) {
                log.warn("responseBody\u4e0d\u80fd\u8f6c\u6362\u4e3aObjectResponse\u5bf9\u8c61: {}", (Object)responseBody);
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u4e3aObjectResponse\u5bf9\u8c61\u5f02\u5e38: {}", (Object)responseBody, (Object)e);
        }
        return response;
    }

    public static <T> ObjectResponse<T> getObjectResponse(String responseBody, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)responseBody)) {
            return null;
        }
        ObjectResponse response = null;
        try {
            Type type = ReflectUtils.getWrapperType(ObjectResponse.class, clazz);
            response = (ObjectResponse)JSONObject.parseObject((String)responseBody, (Type)type, (Feature[])new Feature[0]);
            if (response == null) {
                log.warn("responseBody\u4e0d\u80fd\u8f6c\u6362\u4e3aObjectResponse\u5bf9\u8c61: {}", (Object)responseBody);
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u4e3aObjectResponse\u5bf9\u8c61\u5f02\u5e38: {}", (Object)responseBody, (Object)e);
        }
        return response;
    }

    public static <T> ObjectResponse<List<T>> getListObjectResponse(String responseBody, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)responseBody)) {
            return null;
        }
        ObjectResponse response = null;
        try {
            Type type = ReflectUtils.getLoopWrapperType(ObjectResponse.class, List.class, clazz);
            response = (ObjectResponse)JSONObject.parseObject((String)responseBody, (Type)type, (Feature[])new Feature[0]);
            if (response == null) {
                log.warn("responseBody\u4e0d\u80fd\u8f6c\u6362\u4e3aObjectResponse\u5bf9\u8c61: {}", (Object)responseBody);
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u4e3aObjectResponse\u5bf9\u8c61\u5f02\u5e38: {}", (Object)responseBody, (Object)e);
        }
        return response;
    }

    public static String setNullMsgResponse(String code) {
        return ResponseUtils.setResponse(code, null);
    }

    public static String setResponse(String code, String msg) {
        return ResponseUtils.setResponse(code, msg, null);
    }

    public static String setResponse(String code, String msg, Object data) {
        return JSONObject.toJSONString(ObjectResponse.instance(code, msg, data));
    }

    @Deprecated
    public static <T> ObjectResponse<T> returnSuccessResponse() {
        return new ObjectResponse("200", CodeConstants.getName("200"));
    }

    @Deprecated
    public static <T> ObjectResponse<T> returnSuccessResponse(T t) {
        if (t == null) {
            return new ObjectResponse("200", CodeConstants.getName("200"));
        }
        return new ObjectResponse<T>("200", CodeConstants.getName("200"), t);
    }

    @Deprecated
    public static <T> ObjectResponse<T> returnErrorResponse(String errorCode) {
        return new ObjectResponse(errorCode, CodeConstants.getName(errorCode));
    }

    @Deprecated
    public static <T> ObjectResponse returnErrorResponse(String errorCode, String errorMsg, T t) {
        return new ObjectResponse<T>(errorCode, errorMsg, t);
    }

    @Deprecated
    public static ObjectResponse returnErrorResponse(String errorCode, String errorMsg) {
        return new ObjectResponse(errorCode, errorMsg);
    }

    @Deprecated
    public static <T> ObjectResponse<T> returnNotFoundIfNull(T data) {
        if (data == null) {
            return ResponseUtils.returnErrorResponse("404");
        }
        return ResponseUtils.returnSuccessResponse(data);
    }

    @Deprecated
    public static void notError(ObjectResponse objectResponse) {
        if (objectResponse == null) {
            throw new ResponseBodyException("500", CodeConstants.getName("500"));
        }
        if (!objectResponse.getCode().equals("200")) {
            throw new ResponseBodyException(objectResponse.getCode(), objectResponse.getMsg());
        }
    }

    public static void main(String[] args) {
        String json = "{\"code\":\"200\",\"msg\":\"success\",\"data\": {\"code\": \"201\",\"msg\":\"success1\",\"data\":100}}";
        System.err.println(ResponseUtils.getObjectResponse(json, ObjectResponse.class));
        json = "{\"code\":\"200\",\"msg\":\"success\",\"data\": [{\"code\": \"201\",\"msg\":\"success1\",\"data\":101},{\"code\": \"202\",\"msg\":\"success2\",\"data\":102}]}";
        System.err.println(ResponseUtils.getListObjectResponse(json, ObjectResponse.class));
    }
}

