/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.icetech.common.utils.HttpTools;
import com.icetech.common.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTools {
    private static final Logger log = LoggerFactory.getLogger(DateTools.class);
    public static final String DF = "yyyy-MM-dd HH:mm:ss";
    public static final String DF_DATE = "MM-dd";
    public static final String DF_TIME = "HH:mm";
    public static final String DF_ = "yyyy-MM-dd";
    public static final String DF_DATE_SECOND = "M/dd";
    public static final String DF_TIME_SECOND = "H:mm";
    public static final String DF_TWOBIT = "yyMMddHHmmss";
    public static final String DF_L = "yyyyMMdd";
    public static final String DF_Hms = "HHmmss";
    public static SimpleDateFormat df_date1 = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DF_THREEBIT = "yyMMddHHmmssSSS";
    public static int SPLIT_TYPE_YMD = 1;
    public static int SPLIT_TYPE_OTHER = 2;
    public static final String DF_CN = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    public static final String DF_CN_DATE = "yyyy\u5e74MM\u6708dd\u65e5";

    public static Date getUpDate(Date date) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(date);
            cal.add(5, -1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return cal.getTime();
    }

    public static boolean judge(Date rightStartDate, Date rightEndDate, Date leftStartDate, Date leftEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }

    public static String Timestamp2StringDate(String timestamp, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long time = new Long(timestamp);
        Date date = new Date(time);
        return sdf.format(date);
    }

    public static String StringDate2Timestamp(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date parse = null;
        try {
            parse = sdf.parse(date);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        long time = parse.getTime();
        return String.valueOf(time).substring(0, 10);
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static String getFormat(Date date) {
        return DateTools.getSimpleDateFormat(DF).format(date);
    }

    public static String getFormat(long date) {
        return DateTools.getSimpleDateFormat(DF).format(date);
    }

    public static String getFormat(String format, Date date) {
        return DateTools.getSimpleDateFormat(format).format(date);
    }

    public static String getFormat(String format, long date) {
        return DateTools.getSimpleDateFormat(format).format(date);
    }

    public static Date getParse(String date) {
        try {
            return DateTools.getSimpleDateFormat(DF).parse(date);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date getParse(String format, String date) {
        try {
            return DateTools.getSimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static long time_interval(String date1, String date2) {
        long interval = 0L;
        interval = DateTools.getParse(date2).getTime() - DateTools.getParse(date1).getTime();
        long min = interval / 60L / 1000L;
        return min;
    }

    public static long time_interval(long date1, long date2) {
        long interval = 0L;
        interval = date2 - date1;
        long min = interval / 60L;
        return min;
    }

    public static String secondTostring(int time) {
        return DateTools.getFormat((long)time * 1000L);
    }

    public static String secondTostringDate3(int time) {
        return DateTools.getFormat(DF_, (long)time * 1000L);
    }

    public static String secondTostringDate(int time) {
        return DateTools.getFormat(DF_DATE, (long)time * 1000L);
    }

    public static String secondTostringDate2(int time) {
        return DateTools.getFormat(DF_DATE_SECOND, (long)time * 1000L);
    }

    public static String secondTostringTime(int time) {
        return DateTools.getFormat(DF_TIME, (long)time * 1000L);
    }

    public static String secondTostringTime2(int time) {
        return DateTools.getFormat(DF_TIME_SECOND, (long)time * 1000L);
    }

    public static String secondTotime(int time) {
        String timeStr = null;
        int days = time / 86400;
        int hours = (time - 86400 * days) / 3600;
        int minutes = (time - 86400 * days - 3600 * hours) / 60;
        timeStr = days > 0 ? DateTools.unitFormat(days) + "\u5929" + DateTools.unitFormat(hours) + "\u5c0f\u65f6" + DateTools.unitFormat(minutes) + "\u5206\u949f" : (hours > 0 ? DateTools.unitFormat(hours) + "\u5c0f\u65f6" + DateTools.unitFormat(minutes) + "\u5206\u949f" : DateTools.unitFormat(minutes) + "\u5206\u949f");
        return timeStr;
    }

    public static String secondToSecondsTime(int time) {
        int days = time / 86400;
        int hours = (time - 86400 * days) / 3600;
        int minutes = (time - 86400 * days - 3600 * hours) / 60;
        int seconds = time % 60;
        String timeStr = days > 0 ? DateTools.unitFormat(days) + "\u5929" + DateTools.unitFormat(hours) + "\u5c0f\u65f6" + DateTools.unitFormat(minutes) + "\u5206\u949f" + DateTools.unitFormat(seconds) + "\u79d2" : (hours > 0 ? DateTools.unitFormat(hours) + "\u5c0f\u65f6" + DateTools.unitFormat(minutes) + "\u5206\u949f" + DateTools.unitFormat(seconds) + "\u79d2" : (minutes > 0 ? DateTools.unitFormat(minutes) + "\u5206\u949f" + DateTools.unitFormat(seconds) + "\u79d2" : DateTools.unitFormat(seconds) + "\u79d2"));
        return timeStr;
    }

    public static String minuteTotime(long time) {
        int days = (int)(time / 1440L);
        int hours = (int)(time / 60L - (long)(days * 24));
        int minutes = (int)(time - (long)(hours * 60) - (long)(days * 24 * 60));
        String timeStr = days > 0 ? DateTools.unitFormat(days) + "\u5929" + DateTools.unitFormat(hours) + "\u5c0f\u65f6" + DateTools.unitFormat(minutes) + "\u5206\u949f" : (hours > 0 ? DateTools.unitFormat(hours) + "\u5c0f\u65f6" + DateTools.unitFormat(minutes) + "\u5206\u949f" : DateTools.unitFormat(minutes) + "\u5206\u949f");
        return timeStr;
    }

    public static String unitFormat(int i) {
        String retStr = i > 0 && i < 10 ? "0" + i : "" + i;
        return retStr;
    }

    public static String addTime(String date, int min) {
        return DateTools.getFormat(DateTools.getParse(date).getTime() + (long)(60000 * min));
    }

    public static String nowDate() {
        return Long.toString(System.currentTimeMillis());
    }

    public static String Date() {
        return DateTools.getFormat(new Date());
    }

    public static long unixTimestamp() {
        long time = System.currentTimeMillis();
        return time / 1000L;
    }

    public static int phpCurrentDate(Date date) {
        String datestr = DateTools.getFormat(DF_, date) + " 00:00:00";
        long datalong = 0L;
        datalong = DateTools.getParse(datestr).getTime();
        return (int)(datalong / 1000L);
    }

    public static Date addDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static int addHour(int time, int arg) {
        return time + 3600 * arg;
    }

    public static int addDay(int time, int arg) {
        return time + 86400 * arg;
    }

    public static int addDayFromNow(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        int time = (int)(calendar.getTimeInMillis() / 1000L);
        time = DateTools.addDay(time, day);
        return time;
    }

    public static long timeStr2seconds(String time) {
        if (StringUtils.isNotBlank((CharSequence)time)) {
            time = time.replaceAll("-", "/");
            Date start = new Date(time);
            return start.getTime() / 1000L;
        }
        return 0L;
    }

    public static int getCurrentYear() {
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        return year;
    }

    public static int getCurrentMonth() {
        Calendar now = Calendar.getInstance();
        int month = now.get(2) + 1;
        return month;
    }

    public static String endMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, num + 1);
        calendar.add(5, -1);
        return DateTools.getFormat(DF_, calendar.getTime());
    }

    public static String startMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, num);
        return DateTools.getFormat(DF_, calendar.getTime());
    }

    public static String endWeekDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, num * 7);
        int w = calendar.get(7);
        if (w == 1) {
            w = 8;
        }
        calendar.add(5, 8 - w);
        return DateTools.getFormat(DF_, calendar.getTime());
    }

    public static String startWeekDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, num * 7);
        int w = calendar.get(7);
        calendar.add(5, 2 - w);
        return DateTools.getFormat(DF_, calendar.getTime());
    }

    public static String getNextDate(String date) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(DateTools.getParse(DF_, date));
            cal.add(5, 1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return DateTools.getFormat(DF_, cal.getTime());
    }

    public static String getUpDate(String date) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(DateTools.getParse(DF_, date));
            cal.add(5, -1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return DateTools.getFormat(DF_, cal.getTime());
    }

    public static int compareDate(String date1, String date2) {
        try {
            Date dt1 = DateTools.getParse(date1);
            Date dt2 = DateTools.getParse(date2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static String getNextDate(int num) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.add(5, num);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return DateTools.getFormat(DF_, cal.getTime());
    }

    public static String getNextDate(String date, int num) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(DateTools.getParse(DF_, date));
            cal.add(5, num);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return DateTools.getFormat(DF_, cal.getTime());
    }

    public static String getMonthOfMaxDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, num);
        calendar.add(5, -1);
        return DateTools.getFormat(DF_, calendar.getTime());
    }

    public static String getStartMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, num);
        return DateTools.getFormat(DF_, calendar.getTime());
    }

    public static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        try {
            DateTools.getSimpleDateFormat(DF).setLenient(false);
            str = str.replace("/", "-");
            DateTools.getSimpleDateFormat(DF).parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static String getYear() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(1));
    }

    public static String getMonth() {
        Calendar cal = Calendar.getInstance();
        String month = cal.get(2) + 1 + "";
        if (Integer.parseInt(month) < 10) {
            month = "0" + (cal.get(2) + 1);
        }
        return month;
    }

    public static String getDay() {
        Calendar cal = Calendar.getInstance();
        String date = cal.get(5) + "";
        if (Integer.parseInt(date) < 10) {
            date = "0" + cal.get(5);
        }
        return date;
    }

    public static String getWeek() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(7) - 1);
    }

    public static String getHourtime(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return null;
        }
        int index = time.indexOf(".");
        if (index == -1) {
            time = time + "\u5c0f\u65f6";
        } else {
            String begin = time.substring(0, index);
            String last = time.substring(index, time.length());
            int r1 = Integer.parseInt(begin);
            int r2 = (int)(Double.parseDouble(last) * 60.0);
            time = r1 == 0 ? r2 + "\u5206\u949f" : (r2 == 0 ? r1 + "\u5c0f\u65f6" : r1 + "\u5c0f\u65f6" + r2 + "\u5206\u949f");
        }
        return time;
    }

    public static String getCurrentSecond() {
        long time = System.currentTimeMillis();
        String string = Long.toString(time);
        return string.substring(0, 10);
    }

    public static String stringToDate(String time) throws ParseException {
        if (time.contains("\"")) {
            time = time.replaceAll("\"", "").trim();
        }
        SimpleDateFormat format2 = new SimpleDateFormat(DF_L);
        Date date = null;
        date = format2.parse(time);
        String new_time = DateTools.getFormat(DF_, date);
        return new_time;
    }

    public static String formatDateTime(String time) {
        return time.replace(".0", "");
    }

    public static String addMinute(Date date, int min) {
        return String.format(String.valueOf(date.getTime() + (long)(60000 * min)), new Object[0]);
    }

    public static int addHourFromNow(int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        int time = (int)(calendar.getTimeInMillis() / 1000L);
        time = DateTools.addHour(time, hour);
        return time;
    }

    public static boolean findweekend(String arg) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DF_);
        Date date = sdf.parse(arg);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7) == 1 || calendar.get(7) == 7;
    }

    public static List<String> getBetweenDates(String startTime, String endTime) {
        ArrayList<String> dateList = new ArrayList<String>();
        try {
            Date d1 = df_date1.parse(startTime);
            Date d2 = df_date1.parse(endTime);
            Calendar dd = Calendar.getInstance();
            dd.setTime(d1);
            while (dd.getTime().before(d2) || dd.getTime().equals(d2)) {
                String dateStr = df_date1.format(dd.getTime());
                dateList.add(dateStr);
                dd.add(5, 1);
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return dateList;
    }

    public static String dateDiff(String startTime, String endTime, String format, int splitType) throws ParseException {
        if (StringUtils.isBlankOrNullChar(startTime) || StringUtils.isBlankOrNullChar(endTime)) {
            return "";
        }
        SimpleDateFormat sd = new SimpleDateFormat(format);
        return DateTools.dateDiff(sd.parse(endTime).getTime(), sd.parse(startTime).getTime(), splitType);
    }

    public static String dateDiff(long startTime, long endTime, int splitType) {
        long diff = endTime - startTime;
        return DateTools.dateDiff(diff, splitType);
    }

    public static String dateDiff(long diff, int splitType) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        String result = "";
        if (splitType == SPLIT_TYPE_YMD) {
            result = day != 0L ? day + "\u5929" + hour + "\u65f6" + min + "\u5206" : (hour != 0L ? hour + "\u65f6" + min + "\u5206" : hour + "\u65f6" + min + "\u5206");
        } else if (splitType == SPLIT_TYPE_OTHER) {
            String hourStr = "" + hour;
            String minStr = "" + min;
            String secStr = "" + sec;
            if (hour < 10L) {
                hourStr = "0" + hourStr;
            }
            if (min < 10L) {
                minStr = "0" + minStr;
            }
            if (sec < 10L) {
                secStr = "0" + secStr;
            }
            if (day != 0L) {
                if ((hour += day * 24L) < 10L) {
                    hourStr = "0" + hour;
                }
                result = hour + ":" + minStr + ":" + secStr;
            } else {
                result = hour != 0L ? hourStr + ":" + minStr + ":" + secStr : hourStr + ":" + minStr + ":" + secStr;
            }
        }
        return result;
    }

    public static Long getUTCTime() {
        Calendar cal = Calendar.getInstance();
        int offset = cal.get(15);
        int dstoff = cal.get(16);
        cal.add(14, -(offset + dstoff));
        return cal.getTime().getTime() / 1000L;
    }

    public static long getUnixTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time * 1000L));
        int offset = cal.get(15);
        int dstoff = cal.get(16);
        cal.add(14, -(offset + dstoff));
        return cal.getTime().getTime() / 1000L;
    }

    public static int differentDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static int differentDaysExcludeHMS(Date date1, Date date2) {
        SimpleDateFormat simpleDateFormat = DateTools.getSimpleDateFormat(DF_);
        String ymd1 = simpleDateFormat.format(date1);
        String ymd2 = simpleDateFormat.format(date2);
        try {
            date1 = simpleDateFormat.parse(ymd1);
            date2 = simpleDateFormat.parse(ymd2);
            int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
            return days;
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static Date addMonth(Date sourceDate, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(sourceDate);
        c.add(2, month);
        c.add(5, day);
        return c.getTime();
    }

    public static List<String> getOnlineNotWorkDay(int year) {
        int[] monthArr = new int[]{2, 5, 8, 11};
        ArrayList<String> notWorkDayList = new ArrayList<String>();
        for (int month : monthArr) {
            List<String> noWorkDay = DateTools.getOnlineNotWorkDay(year, month);
            notWorkDayList.addAll(noWorkDay);
        }
        return notWorkDayList;
    }

    private static List<String> getOnlineNotWorkDay(int year, int month) {
        String url = "https://opendata.baidu.com/api.php";
        ArrayList<String> list = new ArrayList<String>();
        String fullUrl = url + "?tn=wisetpl&format=json&resource_id=39043&t=" + System.currentTimeMillis() + "&query=" + year + "\u5e74" + month + "\u6708";
        String response = HttpTools.get(fullUrl);
        log.info("\u8bf7\u6c42\u5f00\u653e\u63a5\u53e3\u53c2\u6570[{}], \u54cd\u5e94[{}]", (Object)fullUrl, (Object)response);
        if (StringUtils.isEmpty((CharSequence)response) || !response.startsWith("{")) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] \u8bf7\u6c42\u5f00\u653e\u63a5\u53e3\u83b7\u53d6\u975e\u5de5\u4f5c\u65e5\u5931\u8d25, response[{}]", (Object)response);
            return list;
        }
        Map map = (Map)JSON.parseObject((String)response, Map.class);
        if (!"0".equals(map.get("status"))) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] \u8bf7\u6c42\u5f00\u653e\u63a5\u53e3\u83b7\u53d6\u975e\u5de5\u4f5c\u65e5\u5931\u8d25, response[{}]", (Object)response);
        }
        JSONArray data = (JSONArray)map.get("data");
        JSONObject o = (JSONObject)data.get(0);
        JSONArray almanac = (JSONArray)o.get((Object)"almanac");
        for (Object o1 : almanac) {
            JSONObject object = (JSONObject)o1;
            String cnDay = (String)object.get((Object)"cnDay");
            String status = (String)object.get((Object)"status");
            if ("\u65e5".equals(cnDay) || "\u516d".equals(cnDay)) {
                if (status == null) {
                    list.add(object.get((Object)"year") + "-" + DateTools.dateCover((String)object.get((Object)"month")) + "-" + DateTools.dateCover((String)object.get((Object)"day")));
                    continue;
                }
                if ("2".equals(status)) continue;
                list.add(object.get((Object)"year") + "-" + DateTools.dateCover((String)object.get((Object)"month")) + "-" + DateTools.dateCover((String)object.get((Object)"day")));
                continue;
            }
            if (!"1".equals(status)) continue;
            list.add(object.get((Object)"year") + "-" + DateTools.dateCover((String)object.get((Object)"month")) + "-" + DateTools.dateCover((String)object.get((Object)"day")));
        }
        return list;
    }

    private static String dateCover(String sourceStr) {
        int num = 2;
        if (sourceStr == null) {
            return null;
        }
        if (sourceStr.length() >= num) {
            return sourceStr;
        }
        int i = num - sourceStr.length();
        StringBuilder prefix = new StringBuilder();
        for (int j = 0; j < i; ++j) {
            prefix.append("0");
        }
        return prefix + sourceStr;
    }
}

