/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.thread;

import com.icetech.common.thread.ScheduleFixTimesRunnable;
import com.icetech.common.utils.Slf4jUtils;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class ScheduleUtils {
    public static <T> void scheduleFixTimesWithFixDelay(ScheduledExecutorService executor, Function<Integer, T> task, int times, long delay) {
        ScheduleUtils.scheduleFixTimesWithFixDelay(executor, task, times, 0L, delay, null);
    }

    public static <T> void scheduleFixTimesWithFixDelay(ScheduledExecutorService executor, Function<Integer, T> task, int times, long initialDelay, long delay) {
        ScheduleUtils.scheduleFixTimesWithFixDelay(executor, task, times, initialDelay, delay, null);
    }

    public static <T> void scheduleFixTimesWithFixDelay(ScheduledExecutorService executor, Function<Integer, T> task, int times, long initialDelay, long delay, Consumer<T> callback) {
        String traceId = Slf4jUtils.getTraceId();
        ScheduleFixTimesRunnable runnable = new ScheduleFixTimesRunnable(traceId, task, times, callback);
        runnable.start(() -> executor.scheduleWithFixedDelay(runnable, initialDelay, delay, TimeUnit.MILLISECONDS));
    }

    public static <T> void scheduleFixTimesWithFixDelay(ThreadPoolTaskScheduler scheduler, Function<Integer, T> task, int times, long delay) {
        ScheduleUtils.scheduleFixTimesWithFixDelay(scheduler, task, times, 0L, delay, null);
    }

    public static <T> void scheduleFixTimesWithFixDelay(ThreadPoolTaskScheduler scheduler, Function<Integer, T> task, int times, long initialDelay, long delay) {
        ScheduleUtils.scheduleFixTimesWithFixDelay(scheduler, task, times, initialDelay, delay, null);
    }

    public static <T> void scheduleFixTimesWithFixDelay(ThreadPoolTaskScheduler scheduler, Function<Integer, T> task, int times, long initialDelay, long delay, Consumer<T> callback) {
        String traceId = Slf4jUtils.getTraceId();
        ScheduleFixTimesRunnable runnable = new ScheduleFixTimesRunnable(traceId, task, times, callback);
        runnable.start(() -> scheduler.scheduleWithFixedDelay((Runnable)runnable, new Date(System.currentTimeMillis() + initialDelay), delay));
    }
}

