/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.content;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.function.Supplier;

public class TenantContextHolder {
    private static final ThreadLocal<String> CONTEXT = new TransmittableThreadLocal();

    public static void setTenantId(String tenantId) {
        CONTEXT.set(tenantId);
    }

    public static String getTenantId() {
        return CONTEXT.get();
    }

    public static void clear() {
        CONTEXT.remove();
    }

    public static <T> T setAndClearTenantId(String tenantId, Supplier<T> supplier) {
        try {
            TenantContextHolder.setTenantId(tenantId);
            T t = supplier.get();
            return t;
        }
        finally {
            TenantContextHolder.clear();
        }
    }
}

