/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ToolsUtil {
    private static final Logger log = LoggerFactory.getLogger(ToolsUtil.class);
    public static Random RANDOM = new Random();
    public static String FORMATDATE = "yyyy-MM-dd";
    public static String FORMATDATEZN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String FORMATTIME = "yyyy-MM-dd HH:mm:ss";
    public static String FORMATTIMEZN = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static int SPLIT_TYPE_YMD = 1;
    public static int SPLIT_TYPE_OTHER = 2;

    public static int compareDate(String date1, String date2) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        try {
            Date dt1 = sdf.parse(date1);
            Date dt2 = sdf.parse(date2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static boolean isNumber(String number) {
        if (ToolsUtil.isNull(number)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[0-9]*$");
        Matcher matcher = pattern.matcher(number);
        return matcher.matches();
    }

    public static String endMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        log.info(String.valueOf(5));
        calendar.set(5, 1);
        log.info(String.valueOf(calendar));
        calendar.add(2, num + 1);
        calendar.add(5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

    public static String startMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, num);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

    public static String endWeekDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, num * 7);
        int w = calendar.get(7);
        if (w == 1) {
            w = 8;
        }
        calendar.add(5, 8 - w);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

    public static String startWeekDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, num * 7);
        int w = calendar.get(7);
        calendar.add(5, 2 - w);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

    public static String getNextDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(date));
            cal.add(5, 1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sdf.format(cal.getTime());
    }

    public static String getUpDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(date));
            cal.add(5, -1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sdf.format(cal.getTime());
    }

    public static String getNextDate(int num) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
            cal.add(5, num);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sdf.format(cal.getTime());
    }

    public static String getNextDate(String date, int num) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(date));
            cal.add(5, num);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sdf.format(cal.getTime());
    }

    public static String getMonthOfMaxDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, num);
        calendar.add(5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

    public static String getStartMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, num);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

    public static Boolean compareStr(String s1, String s2) {
        Collator c = Collator.getInstance();
        return c.compare(s1, s2) == 0;
    }

    public static boolean isWebUrl(String url) {
        if (ToolsUtil.isNull(url)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([a-zA-z]+://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(\\?\\S*)?$");
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    public static boolean isZipCode(String zip) {
        if (ToolsUtil.isNull(zip)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\d{6}$");
        Matcher matcher = pattern.matcher(zip);
        return matcher.matches();
    }

    public static boolean isPhone(String phone) {
        if (ToolsUtil.isNull(phone)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^1[0-9]{10}$");
        Matcher matcher = pattern.matcher(phone);
        return matcher.matches();
    }

    public static boolean isEmail(String email) {
        if (ToolsUtil.isNull(email)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\w+([-.]\\w+)*@\\w+([-]\\w+)*\\.(\\w+([-]\\w+)*\\.)*[a-z]{2,3}$");
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static Hashtable<String, String> getProperty(String where) {
        String[] wheres;
        Hashtable<String, String> wht = new Hashtable<String, String>();
        if (ToolsUtil.isNotNull(where) && (wheres = where.split(";")) != null && wheres.length > 0) {
            for (int i = 0; i < wheres.length; ++i) {
                String[] property = wheres[i].split("=");
                wht.put(property[0], ToolsUtil.toString(property.length > 1 ? ToolsUtil.toString(property[1]) : ""));
            }
        }
        return wht;
    }

    public static String setProperty(Hashtable<?, ?> wht) {
        if (ToolsUtil.isNull(wht)) {
            return "";
        }
        StringBuffer query = new StringBuffer();
        query.append("1=1");
        Iterator<?> it = wht.keySet().iterator();
        while (it.hasNext()) {
            String obj = ToolsUtil.toString(it.next());
            String key = obj.toString();
            String value = ToolsUtil.toString(wht.get(key));
            if (key.equals("1") || !ToolsUtil.isNotNull(value)) continue;
            query.append(";" + key + "=" + value);
        }
        return query.toString();
    }

    public static String parseMoneyString(String str) {
        try {
            if (str.startsWith(".")) {
                return "0" + str;
            }
            if (str.startsWith("0")) {
                return str;
            }
            if (!StringUtils.isNotBlank((CharSequence)str) || "0".equals(str) || str.startsWith(".") || str.startsWith("0")) {
                return "0";
            }
            return new DecimalFormat("#,###.00").format(Double.parseDouble(str));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Deprecated
    public static String parseMoneyFloat(Object str) {
        try {
            if (str == null || StringUtils.isBlank((CharSequence)str.toString()) || "0".equals(str)) {
                return "0";
            }
            return str.toString().replaceAll(",", "");
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static Date parseDate(Object str) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        try {
            return sdf.parse(str.toString());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int parseInt(Object a) {
        if (ToolsUtil.isNull(ToolsUtil.toString(a))) {
            return 0;
        }
        return Integer.parseInt(ToolsUtil.toString(a));
    }

    public static Float parseFloat(Object a) {
        if (ToolsUtil.isNull(ToolsUtil.toString(a))) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(Float.parseFloat(ToolsUtil.toString(a)));
    }

    public static Double parseDouble(Object a) {
        if (ToolsUtil.isNull(ToolsUtil.toString(a))) {
            return 0.0;
        }
        return Double.parseDouble(ToolsUtil.toString(a));
    }

    public static Double parseDouble(Object a, String formater) {
        if (ToolsUtil.isNull(ToolsUtil.toString(a))) {
            return 0.0;
        }
        DecimalFormat formaterObj = new DecimalFormat(formater);
        return NumberUtils.toDouble((String)formaterObj.format(NumberUtils.toDouble((String)ToolsUtil.toString(a))));
    }

    public static Float parseFloat(Object a, String formater) {
        if (ToolsUtil.isNull(ToolsUtil.toString(a))) {
            return Float.valueOf(0.0f);
        }
        DecimalFormat formaterObj = new DecimalFormat(formater);
        return ToolsUtil.parseFloat(formaterObj.format(ToolsUtil.parseFloat(ToolsUtil.toString(a))));
    }

    public static String parseString(Object a, String formater) {
        if (ToolsUtil.isNull(ToolsUtil.toString(a))) {
            return "0.00";
        }
        DecimalFormat formaterObj = new DecimalFormat(formater);
        return formaterObj.format(ToolsUtil.parseFloat(ToolsUtil.toString(a)));
    }

    public static boolean isNotNull(Object obj) {
        return obj != null && !obj.toString().equals("") && !obj.toString().toLowerCase().equals("null");
    }

    public static boolean isNull(Object obj) {
        return obj == null || obj.toString().trim().length() == 0 || obj.toString().toLowerCase().equals("null");
    }

    public static String replace(String source, String oldString, String newString) {
        int pos;
        StringBuffer output = new StringBuffer();
        int lengthOfSource = source.length();
        int lengthOfOld = oldString.length();
        int posStart = 0;
        while ((pos = source.indexOf(oldString, posStart)) >= 0) {
            output.append(source.substring(posStart, pos));
            output.append(newString);
            posStart = pos + lengthOfOld;
        }
        if (posStart < lengthOfSource) {
            output.append(source.substring(posStart));
        }
        return output.toString();
    }

    public static int countStr(String source, char str) {
        int count = 0;
        char[] c = source.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != str) continue;
            ++count;
        }
        return count;
    }

    public static String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(new Date());
    }

    public static String getNowDate(String code) {
        SimpleDateFormat sdf = new SimpleDateFormat(code);
        return sdf.format(new Date());
    }

    public static String getNowDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATTIME);
        return sdf.format(new Date());
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String toString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        if (obj instanceof String) {
            return "";
        }
        if (obj instanceof Integer) {
            return "0";
        }
        if (obj instanceof Double) {
            return "0.0";
        }
        if (obj instanceof Float) {
            return "0.0";
        }
        return "";
    }

    public static double percent(double a, double b) {
        if (a == 0.0) {
            return 0.0;
        }
        return b / a * 100.0;
    }

    public static String getYear() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(1));
    }

    public static String getMonth() {
        Calendar cal = Calendar.getInstance();
        String month = cal.get(2) + 1 + "";
        if (Integer.parseInt(month) < 10) {
            month = "0" + (cal.get(2) + 1);
        }
        return month;
    }

    public static String getDay() {
        Calendar cal = Calendar.getInstance();
        String date = cal.get(5) + "";
        if (Integer.parseInt(date) < 10) {
            date = "0" + cal.get(5);
        }
        return date;
    }

    public static String getWeek() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(7) - 1);
    }

    public static String dateDiff(String startTime, String endTime, String format, int splitType) throws ParseException {
        if (ToolsUtil.isNull(startTime) || ToolsUtil.isNull(endTime)) {
            return "";
        }
        SimpleDateFormat sd = new SimpleDateFormat(format);
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long diff = sd.parse(endTime).getTime() - sd.parse(startTime).getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        String result = "";
        if (splitType == SPLIT_TYPE_YMD) {
            result = day != 0L ? day + "\u5929" + hour + "\u65f6" + min + "\u5206" : (hour != 0L ? hour + "\u65f6" + min + "\u5206" : hour + "\u65f6" + min + "\u5206");
        } else if (splitType == SPLIT_TYPE_OTHER) {
            String hourStr = "" + hour;
            String minStr = "" + min;
            String secStr = "" + sec;
            if (hour < 10L) {
                hourStr = "0" + hourStr;
            }
            if (min < 10L) {
                minStr = "0" + minStr;
            }
            if (sec < 10L) {
                secStr = "0" + secStr;
            }
            if (day != 0L) {
                if ((hour += day * 24L) < 10L) {
                    hourStr = "0" + hour;
                }
                result = hour + ":" + minStr + ":" + secStr;
            } else {
                result = hour != 0L ? hourStr + ":" + minStr + ":" + secStr : hourStr + ":" + minStr + ":" + secStr;
            }
        }
        return result;
    }

    public static String formatPlatenumber(String platenumber) {
        if (StringUtils.isNotBlank((CharSequence)platenumber)) {
            try {
                boolean b = NumberUtils.isCreatable((String)platenumber);
                return b ? "\u672a\u77e5\u8f66\u724c" : platenumber;
            }
            catch (Exception e) {
                return "\u672a\u77e5\u8f66\u724c";
            }
        }
        return "\u672a\u77e5\u8f66\u724c";
    }
}

