/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixSizeCopyOnWriteArrayList<T>
extends CopyOnWriteArrayList<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FixSizeCopyOnWriteArrayList.class);
    private static final long serialVersionUID = 3292612616231532364L;
    private int capacity;

    public FixSizeCopyOnWriteArrayList() {
        this.capacity = 10;
    }

    public FixSizeCopyOnWriteArrayList(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public boolean add(T e) {
        if (this.size() + 1 > this.capacity) {
            super.remove(0);
        }
        return super.add(e);
    }

    public static void main(String[] args) {
        FixSizeCopyOnWriteArrayList<String> list = new FixSizeCopyOnWriteArrayList<String>(3);
        list.add("1234");
        list.add("234");
        list.add("34");
        list.add("4");
        list.add("5");
        log.info(String.valueOf(list.contains("5")));
        log.info(JSON.toJSONString(list));
    }
}

