/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.utils.Base64Tools;
import com.icetech.common.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileTools {
    public static List<String[]> getZipFileContent(File zipFile, String readFileName) throws ZipException, IOException {
        LinkedList<String[]> resultList = new LinkedList<String[]>();
        ZipFile zip = new ZipFile(zipFile, Charset.forName("GBK"));
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (!ze.getName().contains(readFileName)) continue;
            Scanner scanner = new Scanner(zip.getInputStream(ze), "GBK");
            Throwable throwable = null;
            try {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] lineArr = line.split(",");
                    resultList.add(lineArr);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (scanner == null) continue;
                if (throwable != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                scanner.close();
            }
        }
        zip.close();
        return resultList;
    }

    @Deprecated
    public static byte[] downLoadFromUrl(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(1000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        try (InputStream inputStream = conn.getInputStream();){
            byte[] getData;
            byte[] byArray = getData = FileTools.readInputStream(inputStream);
            return byArray;
        }
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static File getFileFromUrl(String url, String fileName) throws IOException {
        byte[] bytes = IOUtils.toByteArray((URL)new URL(url));
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + fileName;
        File saveFile = new File(filePath);
        FileUtils.writeByteArrayToFile((File)saveFile, (byte[])bytes);
        return saveFile;
    }

    public static File getFileFromUrl(String url, String filePath, String fileName) throws IOException {
        byte[] bytes = IOUtils.toByteArray((URL)new URL(url));
        File saveFile = new File(filePath + File.separator + fileName);
        FileUtils.writeByteArrayToFile((File)saveFile, (byte[])bytes);
        return saveFile;
    }

    @Deprecated
    public static void bytesToFile(byte[] buffer, String filePath) throws IOException {
        File file = new File(filePath);
        FileUtils.writeByteArrayToFile((File)file, (byte[])buffer);
    }

    @Deprecated
    public static String encodeBase64File(File file) throws IOException {
        return Base64Tools.encodeBase64String(file);
    }

    public static int base64ToImageOutput(String base64, OutputStream out) throws IOException {
        if (StringUtils.isBlank((CharSequence)base64)) {
            return 0;
        }
        return IOUtils.copy((InputStream)new ByteArrayInputStream(Base64Tools.decodeBase64((String)base64)), (OutputStream)out);
    }

    public static int base64ToImageFile(String base64, String path) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(path);
        return FileTools.base64ToImageOutput(base64, out);
    }
}

