package com.icetech.common.utils;

import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import java.util.UUID;

public class UUIDTools {

	public static String[] chars = { "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z" };

	public static String getUuid(){
//        1~8位采用系统时间，在系统时间上精确到毫秒级保证时间上的惟一性；
//        9~16位采用底层的IP地址，在服务器集群中的惟一性；
//        17~24位采用当前对象的HashCode值，在一个内部对象上的惟一性；
//        25~32位采用调用方法的一个随机数，在一个对象内的毫秒级的惟一性
		return UUID.randomUUID().toString().replace("-", "");
	}
	public static String generateShortUuid(){
		StringBuilder shortBuffer = new StringBuilder();
	    String uuid = UUID.randomUUID().toString().replace("-", "");
	    for (int i = 0; i < 8; i++){
	    	String str = uuid.substring(i * 4, i * 4 + 4);
	    	int x = Integer.parseInt(str, 16);
	    	shortBuffer.append(chars[(x % 62)]);
	    }
	    return shortBuffer.toString();
	}

	public static String getSerialNo(String prefix){
	    return prefix + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + generateShortUuid();
	}

	/**
	 * 生成几位数的验证码
	 * @param num 生成4位 就是4
	 * @return
	 */
	public static String getNonce_str(int num) {
		// 数字
	 	final String SYMBOLS = "0123456789";
		final Random RANDOM = new SecureRandom();
		// 如果需要4位，那 new char[num] 即可，其他位数同理可得
		char[] nonceChars = new char[num];
		for (int index = 0; index < nonceChars.length; ++index) {
			nonceChars[index] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
		}

		return new String(nonceChars);
	}

}
