package com.icetech.common.utils;

import com.icetech.common.constants.CommonConstants;
import org.slf4j.MDC;

public class Slf4jUtils {
    public static String putTraceId() {
        return putTraceId(CodeTools.generateTradeId());
    }

    public static String putTraceId(String traceId) {
        if(StringUtils.isBlank(traceId)) return putTraceId();
        MDC.put(CommonConstants.TRACE_ID_KEY, traceId);
        return traceId;
    }

    public static String putTraceIdIfAbsent() {
        String traceId = getTraceId();
        if (StringUtils.isBlank(traceId)) {
            return putTraceId();
        }
        return traceId;
    }

    public static String putTraceIdIfAbsent(String traceId) {
        String trace = getTraceId();
        if (StringUtils.isBlank(trace)) {
            return putTraceId(traceId);
        }
        return trace;
    }

    /**
     * @deprecated 使用 {@link #putTraceIdIfAbsent()}
     * @return
     */
    @Deprecated
    public static String putTraceIdIfPresent() {
        String traceId = MDC.get(CommonConstants.TRACE_ID_KEY);
        if (StringUtils.isBlank(traceId)) {
            return putTraceId();
        }
        return traceId;
    }

    public static String getTraceId() {
        return MDC.get(CommonConstants.TRACE_ID_KEY);
    }

    public static void removeTraceId() {
        MDC.remove(CommonConstants.TRACE_ID_KEY);
    }
}
