/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.domain.request.BaseRequest;
import com.icetech.common.utils.JsonUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignTools {
    private static final Logger log = LoggerFactory.getLogger(SignTools.class);

    public static boolean verifyMD5Sign(BaseRequest baseRequest, String key) {
        String sign = "";
        String mySign = "";
        String linkString = "";
        try {
            Map<String, Object> map = SignTools.convertMap(baseRequest);
            sign = (String)map.get("sign");
            map.remove("sign");
            linkString = SignTools.getSignContent(map, key);
            mySign = DigestUtils.md5Hex((String)linkString).toUpperCase();
            if (sign.equals(mySign)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("<\u7b7e\u540d\u6821\u9a8c> MD5\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff0cmd5\u7684\u5b57\u7b26\u4e32\uff1a{}\uff0csign\uff1a{}\uff0cmySign\uff1a{}", new Object[]{linkString, sign, mySign});
        return false;
    }

    public static boolean verifyMD5Sign(Object baseRequest, String key) {
        String sign = "";
        String mySign = "";
        String linkString = "";
        try {
            Map<String, Object> map = SignTools.convertMap(baseRequest);
            sign = (String)map.get("sign");
            map.remove("sign");
            linkString = SignTools.getSignContent(map, key);
            mySign = DigestUtils.md5Hex((String)linkString);
            if (sign.equalsIgnoreCase(mySign)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("<\u7b7e\u540d\u6821\u9a8c> MD5\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff0cmd5\u7684\u5b57\u7b26\u4e32\uff1a{}\uff0csign\uff1a{}\uff0cmySign\uff1a{}", new Object[]{linkString, sign, mySign});
        return false;
    }

    public static String getMySign(Map<String, Object> sortedParams, String key) {
        String linkString = "";
        if (null != sortedParams && !sortedParams.isEmpty()) {
            linkString = SignTools.getSignContent(sortedParams, key);
            log.debug("<\u7b7e\u540d\u6821\u9a8c> \u53c2\u4e0e\u7b7e\u540d\u751f\u6210\u7684\u5b57\u7b26\u4e32\u4e3a\uff1a{}", (Object)linkString);
            String mySign = null;
            try {
                mySign = DigestUtils.md5Hex((String)linkString).toUpperCase();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return mySign;
        }
        return null;
    }

    public static String getSignContent(Map<String, Object> sortedParams, String secretKey) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = sortedParams.get(key);
            if (value == null || String.valueOf(value).length() <= 0) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        content.append("&key=" + secretKey);
        return content.toString();
    }

    public static String map2SortJSON(Map<String, Object> map) {
        TreeMap<Object, Object> treeMap = map instanceof TreeMap ? (TreeMap<Object, Object>)map : new TreeMap<String, Object>(map);
        return JsonUtils.toString(treeMap);
    }

    public static Map<String, Object> convertMap(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
        if (bean instanceof Map) {
            Map tempMap = (Map)bean;
            ArrayList keys = new ArrayList(tempMap.keySet());
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                Object value = tempMap.get(key);
                returnMap.put(key, value);
            }
            Object bizContent = returnMap.get("bizContent");
            if (bizContent != null) {
                returnMap.put("bizContent", JsonUtils.toString(bizContent));
            }
        } else {
            Class<?> type = bean.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                Method readMethod;
                Object result;
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (propertyName.equals("class") || (result = (readMethod = descriptor.getReadMethod()).invoke(bean, new Object[0])) == null) continue;
                if (result instanceof Map) {
                    result = JsonUtils.toString(result);
                } else if (propertyName.equals("bizContent") && !(result instanceof String)) {
                    result = JsonUtils.toString(result);
                }
                returnMap.put(propertyName, result);
            }
        }
        return returnMap;
    }

    public static String sign(Object object, String key) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Map<String, Object> map = SignTools.convertMap(object);
        return SignTools.getMySign(map, key);
    }
}

