/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.utils.StringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoneyTool {
    private static final Logger log = LoggerFactory.getLogger(MoneyTool.class);

    public static String fromFenToYuan(String fen) {
        if (fen.equals("0")) {
            return "0";
        }
        String yuan = "";
        int MULTIPLIER = 100;
        Pattern pattern = Pattern.compile("^[1-9][0-9]*{1}");
        Matcher matcher = pattern.matcher(fen);
        if (matcher.matches()) {
            yuan = new BigDecimal(fen).divide(new BigDecimal(100)).setScale(2).toString();
        } else {
            log.info("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        return yuan;
    }

    public static String fromYuanToFen(String yuan) {
        if (null == yuan || "0".equals(yuan) || "".equals(yuan)) {
            return "0";
        }
        String fen = "";
        Pattern pattern = Pattern.compile("^[0-9]+(.[0-9]{1,2})?$");
        Matcher matcher = pattern.matcher(yuan);
        if (matcher.matches()) {
            try {
                NumberFormat format = NumberFormat.getInstance();
                Number number = format.parse(yuan);
                double temp = number.doubleValue() * 100.0;
                format.setGroupingUsed(false);
                format.setMaximumFractionDigits(0);
                fen = format.format(temp);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return fen;
    }

    public static String parseMoneyFloat(String str) {
        try {
            if (!StringUtils.isNotBlank((CharSequence)str) || "0".equals(str)) {
                return "0";
            }
            return str.replaceAll(",", "");
        }
        catch (Exception e) {
            return "0";
        }
    }
}

