/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.icetech.common.utils.ReflectUtils;
import com.icetech.common.utils.SpringUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper OBJECT_MAPPER = (ObjectMapper)SpringUtils.getBean(ObjectMapper.class);

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return JSON.toJSONString((Object)object);
    }

    public static JSONObject parseObject(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return JSON.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static <T> T parseObject(String json, Class<?> clazz, Class<?> ... classes) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return (T)JSON.parseObject((String)json, clazz, (Feature[])new Feature[]{Feature.OrderedField});
        }
        return (T)JSON.parseObject((String)json, (Type)ReflectUtils.getLoopWrapperType(clazz, classes), (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static <T> T parseObject(JSONObject jsonObj, Class<?> clazz, Class<?> ... classes) {
        if (jsonObj == null) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return (T)jsonObj.toJavaObject(clazz);
        }
        return (T)jsonObj.toJavaObject(ReflectUtils.getLoopWrapperType(clazz, classes));
    }

    public static Map<String, Object> parseMap(String json) {
        return JsonUtils.parseObject(json);
    }

    public static <K, V> Map<K, V> parseMap(String json, Class<K> keyClass, Class<V> valueClass) {
        if (json == null) {
            return null;
        }
        return (Map)JSON.parseObject((String)json, (Type)ReflectUtils.getWrapperType(Map.class, keyClass, valueClass), (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static Map<String, String> parseStringMap(String json) {
        return JsonUtils.parseMap(json, String.class, String.class);
    }

    public static <K, V> Map<K, V> parseMap(JSONObject jsonObj, Class<K> keyClass, Class<V> valueClass) {
        if (jsonObj == null) {
            return null;
        }
        return (Map)jsonObj.toJavaObject(ReflectUtils.getWrapperType(Map.class, keyClass, valueClass));
    }

    public static JSONArray parseArray(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return JSON.parseArray((String)json);
    }

    public static <T> List<T> parseArray(String json, Class<?> clazz, Class<?> ... classes) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return (List)JSON.parseObject((String)json, (Type)ReflectUtils.getWrapperType(List.class, clazz), (Feature[])new Feature[]{Feature.OrderedField});
        }
        Class[] paramClass = new Class[classes.length + 1];
        paramClass[0] = clazz;
        System.arraycopy(classes, 0, paramClass, 1, classes.length);
        return (List)JSON.parseObject((String)json, (Type)ReflectUtils.getLoopWrapperType(List.class, paramClass), (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static <T> List<T> parseArray(JSONArray jsonArray, Class<?> clazz, Class<?> ... classes) {
        if (jsonArray == null) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return (List)jsonArray.toJavaObject(ReflectUtils.getWrapperType(List.class, clazz));
        }
        Class[] paramClass = new Class[classes.length + 1];
        paramClass[0] = clazz;
        System.arraycopy(classes, 0, paramClass, 1, classes.length);
        return (List)jsonArray.toJavaObject(ReflectUtils.getLoopWrapperType(List.class, paramClass));
    }

    public static String replaceJsonContent(String json, String ... params) {
        if (params == null || params.length == 0) {
            return json;
        }
        for (String param : params) {
            if (!json.contains(param)) continue;
            int pos1 = json.indexOf(param);
            int length = param.length();
            String leftStr = json.substring(0, pos1 + length + 1);
            String rightStr = json.substring(pos1 + length + 1);
            int pos2 = rightStr.indexOf(",");
            if (pos2 == -1) {
                pos2 = rightStr.indexOf("}");
            }
            String rightStr2 = rightStr.substring(pos2);
            json = leftStr + ":\"(\u66ff\u4ee3\u663e\u793a\u5185\u5bb9)\"" + rightStr2;
        }
        return json;
    }

    public static <T> T convert2bean(Object obj, Class<T> clazz) {
        String json = JsonUtils.toString(obj);
        return JsonUtils.parseObject(json, clazz, new Class[0]);
    }

    public static Dict parseDict(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            return (Dict)OBJECT_MAPPER.readValue(text, OBJECT_MAPPER.getTypeFactory().constructType(Dict.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(Object object) {
        if (ObjectUtil.isNull((Object)object)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

