/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpTools {
    private static final Logger log = LoggerFactory.getLogger(FtpTools.class);
    private static FTPClient ftpClient = new FTPClient();
    private static String encoding = System.getProperty("file.encoding");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(String url, int port, String username, String password, String path, String filename, InputStream input) {
        boolean result = false;
        try {
            ftpClient.connect(url);
            ftpClient.login(username, password);
            ftpClient.setControlEncoding(encoding);
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                log.info("\u8fde\u63a5\u5931\u8d25");
                ftpClient.disconnect();
                boolean bl = result;
                return bl;
            }
            boolean change = ftpClient.changeWorkingDirectory(path);
            ftpClient.setFileType(2);
            if (change && (result = ftpClient.storeFile(new String(filename.getBytes(encoding), "iso-8859-1"), input))) {
                log.info("\u4e0a\u4f20\u6210\u529f!");
            }
            input.close();
            ftpClient.logout();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downFile(String url, int port, String username, String password, String remotePath, String fileName, String localPath) {
        boolean result = false;
        try {
            FTPFile[] fs;
            ftpClient.setControlEncoding(encoding);
            ftpClient.connect(url, port);
            ftpClient.login(username, password);
            ftpClient.setFileType(2);
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftpClient.disconnect();
                log.error("FTP server refused connection.");
                boolean bl = result;
                return bl;
            }
            ftpClient.changeWorkingDirectory(new String(remotePath.getBytes(encoding), "iso-8859-1"));
            for (FTPFile ff : fs = ftpClient.listFiles()) {
                if (!ff.getName().equals(fileName)) continue;
                File localFile = new File(localPath + "/" + ff.getName());
                FileOutputStream is = new FileOutputStream(localFile);
                ftpClient.retrieveFile(ff.getName(), (OutputStream)is);
                ((OutputStream)is).close();
            }
            ftpClient.logout();
            result = true;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public void testDownFile() {
        try {
            boolean flag = FtpTools.downFile("112.95.215.113", 21, "qs", "ylink!1qaz", "/checkFile/access/7000000000000032/20180825/", "70000000000000322018082501.TXT", "E:/");
            log.info(String.valueOf(flag));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void testUpLoadFromDisk() {
        try {
            FileInputStream in = new FileInputStream(new File("D:/test02/list.txt"));
            boolean flag = FtpTools.uploadFile("10.0.0.102", 21, "admin", "123456", "/", "lis.txt", in);
            log.info(String.valueOf(flag));
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FtpTools fa = new FtpTools();
        fa.testDownFile();
    }
}

