/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil
extends cn.hutool.core.io.FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReadFile(String filePath) throws IOException {
        try (InputStream stream = null;){
            String text;
            stream = ClassUtils.class.getClassLoader().getResourceAsStream(filePath);
            assert (stream != null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, CharsetUtil.CHARSET_UTF_8));
            StringBuilder buffer = new StringBuilder();
            while ((text = reader.readLine()) != null) {
                buffer.append(text);
            }
            String string = buffer.toString();
            return string;
        }
    }

    public static String getReadIoFile(String filePath) throws IOException {
        try (InputStream stream = null;){
            stream = ClassUtils.class.getClassLoader().getResourceAsStream(filePath);
            if (stream == null) {
                log.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8def\u5f84\uff1a{}", (Object)filePath);
                String string = "";
                return string;
            }
            String string = IoUtil.read((InputStream)stream, (Charset)CharsetUtil.CHARSET_UTF_8);
            return string;
        }
    }

    public static void setAttachmentResponseHeader(HttpServletResponse response, String realFileName) throws UnsupportedEncodingException {
        String percentEncodedFileName = FileUtil.percentEncode(realFileName);
        StringBuilder contentDispositionValue = new StringBuilder();
        contentDispositionValue.append("attachment; filename=").append(percentEncodedFileName).append(";").append("filename*=").append("utf-8''").append(percentEncodedFileName);
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition,download-filename");
        response.setHeader("Content-disposition", contentDispositionValue.toString());
        response.setHeader("download-filename", percentEncodedFileName);
    }

    public static String percentEncode(String s) throws UnsupportedEncodingException {
        String encode = URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        return encode.replaceAll("\\+", "%20");
    }
}

