/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.domain.response;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.MessageUtils;
import com.icetech.common.utils.Slf4jUtils;
import java.util.Collection;

public class ObjectResponse<T>
extends Response {
    protected T data;
    protected String traceId = Slf4jUtils.getTraceId();

    public ObjectResponse(String code, String msg) {
        this(code, msg, null);
    }

    public ObjectResponse(String code, String msg, T data) {
        this.setCode(code);
        this.setMsg(msg);
        this.setData(data);
    }

    public static <T> ObjectResponse<T> instance(String code, T data) {
        return ObjectResponse.instance(code, CodeConstants.getName(code), data);
    }

    public static <T> ObjectResponse<T> instance(String code, String msg, T data) {
        return new ObjectResponse<T>(code, msg, data);
    }

    public static <T> ObjectResponse<T> instance(Response response) {
        return ObjectResponse.instance(response.getCode(), response.getMsg(), null);
    }

    public static <T> ObjectResponse<T> success() {
        return ObjectResponse.success(null);
    }

    public static <T> ObjectResponse<T> success(T data) {
        return ObjectResponse.instance("200", data);
    }

    public static <T> ObjectResponse<T> failed() {
        return ObjectResponse.failed(CodeConstantsEnum.ERROR);
    }

    public static <T> ObjectResponse<T> failed(ResponseBodyException exception) {
        return ObjectResponse.failed(exception.getErrCode(), exception.getMessage());
    }

    @Deprecated
    public static <T> ObjectResponse<T> failed(Response response) {
        return ObjectResponse.failed(response.getCode(), response.getMsg());
    }

    public static <T> ObjectResponse<T> failed(CodeConstantsEnum code) {
        return ObjectResponse.failed(code.getCode(), code.getDesc());
    }

    public static <T> ObjectResponse<T> failed(String code) {
        return ObjectResponse.failed(code, CodeConstants.getName(code));
    }

    public static <T> ObjectResponse<T> failed(String code, String msg) {
        return new ObjectResponse<Object>(code, MessageUtils.message(code, msg, new Object[0]), null);
    }

    public static <T> ObjectResponse<T> failed(String code, Object ... args) {
        return new ObjectResponse<Object>(code, MessageUtils.message(code, args), null);
    }

    public static <T> ObjectResponse<T> failedMsg(String code, String msg) {
        return new ObjectResponse<Object>(code, msg, null);
    }

    public static <T> ObjectResponse<T> returnNotFoundIfNull(T data) {
        if (data == null) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(data);
    }

    public static <T extends Collection<?>> ObjectResponse<T> returnNotFoundIfEmpty(T data) {
        if (data == null || data.isEmpty()) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(data);
    }

    public T getData() {
        return this.data;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Override
    public String toString() {
        return "ObjectResponse(super=" + super.toString() + ", data=" + this.getData() + ", traceId=" + this.getTraceId() + ")";
    }

    public ObjectResponse() {
    }

    public ObjectResponse(T data, String traceId) {
        this.data = data;
        this.traceId = traceId;
    }
}

