/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.utils.Base64Tools;
import java.nio.charset.Charset;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTools {
    private static final Logger log = LoggerFactory.getLogger(SecurityTools.class);
    private static final String ALGORITHM_3DES = "DESede";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public static byte[] encrypt3DES(String encryptPassword, byte[] encryptByte) {
        try {
            Cipher cipher = SecurityTools.init3DES(encryptPassword, 1);
            return cipher.doFinal(encryptByte);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encrypt3DES(String encryptPassword, String encryptStr) {
        try {
            Cipher cipher = SecurityTools.init3DES(encryptPassword, 1);
            byte[] enBytes = cipher.doFinal(encryptStr.getBytes(DEFAULT_CHARSET));
            return Base64Tools.encodeBase64String((byte[])enBytes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt3DES(String decryptPassword, byte[] decryptByte) {
        try {
            Cipher cipher = SecurityTools.init3DES(decryptPassword, 2);
            return cipher.doFinal(decryptByte);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decrypt3DES(String decryptPassword, String decryptString) {
        try {
            Cipher cipher = SecurityTools.init3DES(decryptPassword, 2);
            byte[] deBytes = cipher.doFinal(Base64Tools.decodeBase64((String)decryptString));
            return new String(deBytes, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Cipher init3DES(String decryptPassword, int cipherMode) throws Exception {
        SecretKeySpec deskey = new SecretKeySpec(decryptPassword.getBytes(), ALGORITHM_3DES);
        Cipher cipher = Cipher.getInstance(ALGORITHM_3DES);
        cipher.init(cipherMode, deskey);
        return cipher;
    }
}

