/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.domain.route;

import com.icetech.common.domain.route.RouteDefinition;
import com.icetech.common.domain.route.ServiceDefinition;
import com.icetech.common.domain.route.TargetRoute;
import org.springframework.util.StringUtils;

public class GatewayTargetRoute
implements TargetRoute {
    private ServiceDefinition serviceDefinition;
    private RouteDefinition routeDefinition;

    public GatewayTargetRoute(ServiceDefinition serviceDefinition, RouteDefinition routeDefinition) {
        this.serviceDefinition = serviceDefinition;
        this.routeDefinition = routeDefinition;
    }

    @Override
    public String getFullPath() {
        String serviceId = this.serviceDefinition.getServiceId();
        String path = StringUtils.trimLeadingCharacter((String)this.routeDefinition.getPath(), (char)'/');
        return "/" + serviceId + "/" + path;
    }

    @Override
    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    @Override
    public RouteDefinition getRouteDefinition() {
        return this.routeDefinition;
    }
}

