/**
 * Create on Mar 9, 2017
 * Copyright 2011 VisualProject All Rights Reserved.
 */
package com.icetech.common.utils;

import lombok.extern.slf4j.Slf4j;

import java.text.Collator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 开发工具类
 * @author fangct
 * @since version1.0
 */
@Slf4j
@Deprecated
public class ToolsUtil {

	public static Random RANDOM = new Random();
	public static String FORMATDATE = "yyyy-MM-dd";
	public static String FORMATDATEZN = "yyyy年MM月dd日";
	public static String FORMATTIME = "yyyy-MM-dd HH:mm:ss";
	public static String FORMATTIMEZN = "yyyy年MM月dd日 HH时mm分ss秒";
//	public static SimpleDateFormat SDF = new SimpleDateFormat(FORMATDATE);
//	public static SimpleDateFormat STF = new SimpleDateFormat(FORMATTIME);
	public static int SPLIT_TYPE_YMD = 1;
	public static int SPLIT_TYPE_OTHER = 2;

	/**
	 * 比较时间大小
	 * @param date1 日期1
	 * @param date2 日期2
	 * @return 当日期1大于日期2则返回1，小于返回-1，相等返回0
	 */
	public static int compareDate(String date1,String date2){
		SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        try {
            Date dt1 = sdf.parse(date1);
            Date dt2 = sdf.parse(date2);
            if(dt1.getTime() > dt2.getTime()){
            	return 1;
            }else if(dt1.getTime() < dt2.getTime()){
            	return -1;
            }else{
            	return 0;
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return 0;
	}

	/**
	 * 判断是否为数字
	 * @param number 数据
	 * @return 如果是数字类型返回true，否则false
	 */
	public static boolean isNumber(String number){
		if (isNull(number)) {
			return false;
		}
		Pattern pattern = Pattern.compile("^[0-9]*$");
		Matcher matcher = pattern.matcher(number);
		if (matcher.matches()) {
			return true;
		}
		return false;
	}

	/**
	 * 本月末一天
	 * @param num
	 * @return
	 */
	public static String endMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        log.info(String.valueOf(Calendar.DATE));
        calendar.set(Calendar.DATE, 1);
        log.info(String.valueOf(calendar));
        calendar.add(Calendar.MONTH, num + 1);
        calendar.add(Calendar.DATE, -1);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

	/**
	 * 本月第一天
	 * @param num
	 * @return
	 */
	public static String startMonthDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DATE, 1);
        calendar.add(Calendar.MONTH, num);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

	/**
	 * 最后周
	 */
	public static String endWeekDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, num * 7);
        int w = calendar.get(Calendar.DAY_OF_WEEK);
        if (w == 1)
            w = 8;
        calendar.add(Calendar.DATE, 8 - w);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

	/**
	 * 开始周
	 * @param num
	 * @return
	 */
	public static String startWeekDate(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, num * 7);
        int w = calendar.get(Calendar.DAY_OF_WEEK);
        calendar.add(Calendar.DATE, 2 - w);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        return sdf.format(calendar.getTime());
    }

	/**
	 * 获取指定日期的下一天
	 * @param date
	 * @return
	 */
	public static String getNextDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(date));
            cal.add(Calendar.DATE, 1);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return sdf.format(cal.getTime());
    }

	/**
	 * 获取指定日期的上一天
	 * @param date
	 * @return
	 */
    public static String getUpDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(date));
            cal.add(Calendar.DATE, -1);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return sdf.format(cal.getTime());
    }

	/**
	 * 根据当前时间添加指定天数获取下一日期
	 * @param num 添加天数
	 * @return 日期
	 */
	public static String getNextDate(int num) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
            cal.add(Calendar.DATE, num);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return sdf.format(cal.getTime());
    }

	/**
	 * 根据指定时间添加指定天数获取下一日期
	 * @param date 时间
	 * @param num 添加天数
	 * @return 日期
	 */
	public static String getNextDate(String date,int num) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
        Calendar cal = Calendar.getInstance();
        try {
        	cal.setTime(sdf.parse(date));
            cal.add(Calendar.DATE, num);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return sdf.format(cal.getTime());
    }

	/**
	 * 获取指定月下最大日期
	 * @param num
	 * @return
	 */
	public static String getMonthOfMaxDate(int num) {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.DATE, 1);
		calendar.set(Calendar.MONTH, num);
		calendar.add(Calendar.DATE, -1);
		SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
		return sdf.format(calendar.getTime());
	}


	/**
	 * 当前月增加多少个月
	 *
	 * @param num
	 * @return
	 */
	public static String getStartMonthDate(int num) {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.DATE, 1);
		calendar.add(Calendar.MONTH, num);
		SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
		return sdf.format(calendar.getTime());
	}

	/**
	 * 对比字符串是否相等 相等返回true
	 *
	 * @param s1
	 * @param s2
	 * @return
	 */
	public static Boolean compareStr(String s1, String s2) {
		Collator c = Collator.getInstance();
		return c.compare(s1, s2) == 0;
	}


	/**
	 * 判断网站地址是否正确
	 */
	public static boolean isWebUrl(String url) {
		if (isNull(url)) {
			return false;
		}
		Pattern pattern = Pattern
				.compile("^([a-zA-z]+://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(\\?\\S*)?$");
		Matcher matcher = pattern.matcher(url);
		if (matcher.matches()) {
			return true;
		}
		return false;
	}

	/**
	 * 判断邮政编码是否正确
	 */
	public static boolean isZipCode(String zip) {
		if (isNull(zip)) {
			return false;
		}
		Pattern pattern = Pattern.compile("^\\d{6}$");
		Matcher matcher = pattern.matcher(zip);
		if (matcher.matches()) {
			return true;
		}
		return false;
	}

	/**
	 * 判断手机号是否正确
	 */
	public static boolean isPhone(String phone) {
		if (isNull(phone)) {
			return false;
		}
		Pattern pattern = Pattern.compile("^1[0-9]{10}$");
		Matcher matcher = pattern.matcher(phone);
		if (matcher.matches()) {
			return true;
		}
		return false;
	}

	/**
	 * 判断邮箱是否正确
	 */
	public static boolean isEmail(String email) {
		if (isNull(email)) {
			return false;
		}
		Pattern pattern = Pattern
				.compile("^\\w+([-.]\\w+)*@\\w+([-]\\w+)*\\.(\\w+([-]\\w+)*\\.)*[a-z]{2,3}$");
		Matcher matcher = pattern.matcher(email);
		if (matcher.matches()) {
			return true;
		}
		return false;
	}

	/**
	 * 获取所有查询条件
	 */
	public static Hashtable<String, String> getProperty(String where) {
		// 将条件转换为Hashtable
		Hashtable<String, String> wht = new Hashtable<String, String>();
		if (isNotNull(where)) {
			String[] wheres = where.split(";");
			if (wheres != null && wheres.length > 0) {
				for (int i = 0; i < wheres.length; i++) {
					String[] property = wheres[i].split("=");
					wht.put(property[0],toString(property.length > 1 ? toString(property[1]): ""));
				}
			}
		}
		return wht;
	}

	/**
	 * 处理查询条件
	 */
	public static String setProperty(Hashtable<?, ?> wht) {
		if (isNull(wht)) {
			return "";
		}
		StringBuffer query = new StringBuffer();
		// 如果条件为空
		query.append("1=1");
		// 迭代并处理条件
		Iterator<?> it = wht.keySet().iterator();
		while (it.hasNext()) {
			Object obj = toString(it.next());
			String key = obj.toString();
			String value = toString(wht.get(key));
			// 获取键值对
			if (!key.equals("1") && isNotNull(value)) {
				query.append(";" + key + "=" + value);
			}
		}
		return query.toString();
	}

	/**
	 * 将数字解释为财务数字格式显示
	 */
	public static String parseMoneyString(String str) {
		try {
			if (str.startsWith(".")) {
				return "0" + str;
			}
			if (str.startsWith("0")) {
				return str;
			}
			if (!StringUtils.isNotBlank(str) || "0".equals(str)
					|| str.startsWith(".") || str.startsWith("0")) {
				return "0";
			} else {
				return (new DecimalFormat("#,###.00")).format(Double
						.parseDouble(str));
			}
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * <p>把财务格式的数字转成浮点数</p>
	 */
	@Deprecated
	public static String parseMoneyFloat(Object str) {
		try {
			if (str == null || StringUtils.isBlank(str.toString()) || "0".equals(str)) {
				return "0";
			} else {
				return str.toString().replaceAll(",", "");
			}
		} catch (Exception e) {
			return "0";
		}
	}

	/**
	 * 将字符串转换成时间类型
	 *
	 * @param str
	 * @return
	 */
	public static Date parseDate(Object str) {
		SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
		try {
			return sdf.parse(str.toString());
		} catch (ParseException e) {
			log.error(e.getMessage(), e);
		}
		return null;
	}

	/**
	 * 转换整数，无需关心是否为空
	 *
	 * @param a
	 * @return
	 */
	public static int parseInt(Object a) {
		if(isNull(toString(a))){
			return 0;
		}
		return Integer.parseInt(toString(a));
	}

	/**
	 * 转换浮点型，无需关心是否为空
	 *
	 * @param a
	 * @return
	 */
	public static Float parseFloat(Object a) {
		if(isNull(toString(a))){
			return 0.0f;
		}
		return Float.parseFloat(toString(a));
	}

	/**
	 * 转换双精度型，无需关心是否为空
	 *
	 * @param a
	 * @return
	 */
	public static Double parseDouble(Object a) {
		if(isNull(toString(a))){
			return 0.0;
		}
		return Double.parseDouble(toString(a));
	}

	/**
	 * 转换双精度型，无需关心是否为空
	 *
	 * @param a
	 * @return
	 */
	public static Double parseDouble(Object a,String formater) {
		if(isNull(toString(a))){
			return 0.0;
		}
		DecimalFormat formaterObj = new DecimalFormat(formater);
		return NumberUtils.toDouble(formaterObj.format(NumberUtils.toDouble(toString(a))));
	}

	/**
	 * 转换浮点型，无需关心是否为空
	 *
	 * @param a
	 * @return
	 */
	public static Float parseFloat(Object a,String formater) {
		if(isNull(toString(a))){
			return 0.00f;
		}
		DecimalFormat formaterObj = new DecimalFormat(formater);
		return ToolsUtil.parseFloat(formaterObj.format(ToolsUtil.parseFloat(toString(a))));
	}

	/**
	 * 转换字符型，无需关心是否为空
	 *
	 * @param a
	 * @return
	 */
	public static String parseString(Object a,String formater) {
		if(isNull(toString(a))){
			return "0.00";
		}
		DecimalFormat formaterObj = new DecimalFormat(formater);
		return formaterObj.format(ToolsUtil.parseFloat(toString(a)));
	}

	/**
	 * 判断不是空
	 *
	 * @param obj
	 * @return
	 */
	public static boolean isNotNull(Object obj) {
		if (obj == null || obj.toString().equals("")
				|| obj.toString().toLowerCase().equals("null"))
			return false;
		return true;
	}

	/**
	 * 判断是空
	 *
	 * @param obj
	 * @return
	 */
	public static boolean isNull(Object obj) {
		if (obj == null || obj.toString().trim().length() == 0
				|| obj.toString().toLowerCase().equals("null")){
			return true;
		}
		return false;
	}

	/**
	 * 替换字符串
	 *
	 * @param source
	 *            源
	 * @param oldString
	 *            需要替换的旧字符
	 * @param newString
	 *            需要替换的新字符
	 * @return
	 */
	public static String replace(String source, String oldString,
			String newString) {
		StringBuffer output = new StringBuffer();

		int lengthOfSource = source.length();
		int lengthOfOld = oldString.length();

		int posStart = 0;
		int pos;

		while ((pos = source.indexOf(oldString, posStart)) >= 0) {
			output.append(source.substring(posStart, pos));

			output.append(newString);
			posStart = pos + lengthOfOld;
		}

		if (posStart < lengthOfSource) {
			output.append(source.substring(posStart));
		}

		return output.toString();
	}

	/**
	 * 统计字符串中包含个数
	 * @param source 字符串源
	 * @param str 检查的字符串
	 * @return 个数
	 */
	public static int countStr(String source, char str) {
		int count = 0;
		char c[] = source.toCharArray();
		for (int i = 0; i < c.length; i++) {
			if(c[i]==str){
				count++;
			}
		}
		return count;
	}

	/**
	 * 获取当前日期 格式：yyyy-MM-dd
	 *
	 * @return
	 */
	public static String getNowDate() {
		SimpleDateFormat sdf = new SimpleDateFormat(FORMATDATE);
		return sdf.format(new Date());
	}

	/**
	 * 获取当前日期 格式：指定格式的日期
	 *
	 * @return
	 */
	public static String getNowDate(String code) {
		SimpleDateFormat sdf = new SimpleDateFormat(code);
		return sdf.format(new Date());
	}

	/**
	 * 获取当前时间 格式：yyyy-MM-dd HH:mm:ss
	 *
	 * @return
	 */
	public static String getNowDateTime() {
		SimpleDateFormat sdf = new SimpleDateFormat(FORMATTIME);
		return sdf.format(new Date());
	}

	/**
	 * 将转换UTF8格式
	 *
	 * @param s
	 * @return
	 */
	public static String toUtf8String(String s) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c >= 0 && c <= 255) {
				sb.append(c);
			} else {
				byte[] b;
				try {
					b = Character.toString(c).getBytes("utf-8");
				} catch (Exception e) {
					log.error(e.getMessage(), e);
					b = new byte[0];
				}
				for (int j = 0; j < b.length; j++) {
					int k = b[j];
					if (k < 0)
						k += 256;
					sb.append("%" + Integer.toHexString(k).toUpperCase());
				}
			}
		}
		return sb.toString();
	}

	/**
	 * 按照不同类型进行转换防止报NULL
	 *
	 * @param obj
	 * @return
	 */
	public static String toString(Object obj) {
		if (obj != null) {
			return obj.toString();
		} else {
			if (obj instanceof String) {
				return "";
			}
			if (obj instanceof Integer) {
				return "0";
			}
			if (obj instanceof Double) {
				return "0.0";
			}
			if (obj instanceof Float) {
				return "0.0";
			}
			return "";
		}
	}

	/**
	 * 计算百分比
	 *
	 * @param a
	 * @param b
	 * @return
	 */
	public static double percent(double a, double b) {
		if (a == 0) {
			return 0;
		}
		return (b / a) * 100;
	}

	/**
	 * 取当前年
	 *
	 * @return
	 */
	public static String getYear() {
		Calendar cal = Calendar.getInstance();
		return String.valueOf(cal.get(Calendar.YEAR));
	}

	/**
	 * 取当前月
	 *
	 * @return
	 */
	public static String getMonth() {
		Calendar cal = Calendar.getInstance();
		String month = (cal.get(Calendar.MONTH) + 1) + "";
		if (Integer.parseInt(month) < 10)
			month = "0" + (cal.get(Calendar.MONTH) + 1);
		return month;
	}

	/**
	 * 取当前天
	 *
	 * @return
	 */
	public static String getDay() {
		Calendar cal = Calendar.getInstance();
		String date = cal.get(Calendar.DAY_OF_MONTH) + "";
		if (Integer.parseInt(date) < 10)
			date = "0" + cal.get(Calendar.DAY_OF_MONTH);
		return date;
	}

	/**
	 * 取当前星期
	 *
	 * @return
	 */
	public static String getWeek() {
		Calendar cal = Calendar.getInstance();
		return String.valueOf(cal.get(Calendar.DAY_OF_WEEK) - 1);
	}
	/**
	 * 开始日期与结束日期相差多久（[*天]*时*分）
	 * @param startTime 开始日期
	 * @param endTime 结束日期
	 * @param format
	 * @param splitType 分隔类型 1："*天*时*分"，2："时:分:秒"
	 * @return
	 * @throws ParseException
	 */
	public static String dateDiff(String startTime, String endTime, String format,int splitType) throws ParseException {
		if(isNull(startTime) || isNull(endTime))
			return "";
		//按照传入的格式生成一个simpledateformate对象
		SimpleDateFormat sd = new SimpleDateFormat(format);
		long nd = 1000*24*60*60;//一天的毫秒数
		long nh = 1000*60*60;//一小时的毫秒数
		long nm = 1000*60;//一分钟的毫秒数
		long ns = 1000;//一秒钟的毫秒数long diff;try {
		//获得两个时间的毫秒时间差异
		long diff = sd.parse(endTime).getTime() - sd.parse(startTime).getTime();
		long day = diff/nd;//计算差多少天
		long hour = diff%nd/nh;//计算差多少小时
		long min = diff%nd%nh/nm;//计算差多少分钟
		long sec = diff%nd%nh%nm/ns;//计算差多少秒//输出结果
		String result = "";
		if(splitType == SPLIT_TYPE_YMD){
			if(day != 0){
				result = day+"天"+hour+"时"+min+"分";
			}else if(hour != 0){
				result = hour+"时"+min+"分";
			}else{
				result = hour+"时"+min+"分";
			}
		}else if(splitType == SPLIT_TYPE_OTHER){
			String hourStr = ""+hour;
			String minStr = ""+min;
			String secStr = ""+sec;
			if(hour < 10) hourStr = "0" + hourStr;
			if(min < 10) minStr = "0" + minStr;
			if(sec < 10) secStr = "0" + secStr;
			if(day != 0){
				hour = hour + day * 24;
				if(hour < 10) hourStr = "0" + hour;
				result = hour+":"+minStr+":"+secStr;
			}else if(hour != 0){
				result = hourStr+":"+minStr+":"+secStr;
			}else{
				result = hourStr+":"+minStr+":"+secStr;
			}
		}
		return result;
	}
	/**
	 * 全为数字时  格式化车牌号
	 * @param platenumber
	 * @return
	 */
	public static String formatPlatenumber(String platenumber){
		if(StringUtils.isNotBlank(platenumber)){
			try {
				boolean b = NumberUtils.isCreatable(platenumber);
				return b?"未知车牌":platenumber;
			} catch (Exception e) {
				return "未知车牌";
			}
		}else{
			return "未知车牌";
		}
	}
}
