package com.icetech.common.utils;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Base64Tools extends Base64 {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static String encode2String(byte[] bytes){
        return Base64.encodeBase64String(bytes);
    }

    public static String encode2String(String targetString){
        byte[] bytes = targetString.getBytes(DEFAULT_CHARSET);
        return Base64.encodeBase64String(bytes);
    }

    public static String encodeBase64String(File file) throws IOException {
        byte[] bytes = FileUtils.readFileToByteArray(file);
        return encodeBase64String(bytes);
    }

    public static String encodeBase64String(String content) {
        return encodeBase64String(content.getBytes(DEFAULT_CHARSET));
    }

    public static String encode2FileUrl(String url) throws IOException {
        byte[] bytes = IOUtils.toByteArray(new URL(url));
        return encodeBase64String(bytes);
    }

    public static String decodeBase64String(String targetString) {
        return new String(decodeBase64(targetString));
    }

    public static byte[] encode2Byte(String targetString){
        byte[] bytes = targetString.getBytes(DEFAULT_CHARSET);
        return encodeBase64(bytes);
    }

    public static byte[] decode2Byte(String targetString){
        byte[] bytes = targetString.getBytes(DEFAULT_CHARSET);
        return decodeBase64(bytes);
    }

    /**
     *
     * @deprecated {@link Base64Tools#decodeBase64String(String)}
     * @param targetString
     * @return
     */
    @Deprecated
    public static String decode2String(String targetString){
        return decodeBase64String(targetString);
    }
}
