/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.validator;

import com.icetech.common.annotation.AnyOneNotNull;
import com.icetech.common.annotation.NotNull;
import com.icetech.common.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String[] RELATION_TARGET_KEY = new String[]{" and ", " or "};
    private static final String[] RELATION_REPLACEMENT_KEY = new String[]{" AND ", " OR "};
    private static final String EQUAL_EXPRESSION = "==";

    public static boolean validate(Object instance) {
        if (instance == null) {
            return false;
        }
        Class<?> clz = instance.getClass();
        Field[] fs = clz.getDeclaredFields();
        try {
            return Validator.validate(clz, instance, fs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean validate(Class clz, Object instance, Field[] fs) throws IllegalAccessException, NoSuchFieldException {
        boolean finalRes;
        StringBuffer msgString = new StringBuffer("<\u53c2\u6570\u6821\u9a8c> \u6821\u9a8c\u5931\u8d25\uff0c");
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        HashMap<String, String> msgTemp = new HashMap<String, String>();
        boolean anyOneNotNullFlag = true;
        StringBuffer propertyTemp = new StringBuffer("\u5fc5\u586b\u53c2\u6570\uff1a");
        boolean notNullFlag = true;
        for (Field field : fs) {
            boolean tg;
            field.setAccessible(true);
            NotNull notNull = field.getAnnotation(NotNull.class);
            AnyOneNotNull anyOneNotNull = field.getAnnotation(AnyOneNotNull.class);
            if (anyOneNotNull != null) {
                Validator.dealAnyOneNotNull(instance, resultMap, msgTemp, field, anyOneNotNull);
                continue;
            }
            if (notNull == null || (tg = Validator.dealNotNull(clz, instance, notNull, field, propertyTemp))) continue;
            notNullFlag = false;
        }
        StringBuffer stringBuffer = new StringBuffer("\u4efb\u4e00\u5fc5\u586b\u53c2\u6570\uff1a");
        ArrayList keys = new ArrayList(msgTemp.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = (String)msgTemp.get(key);
            stringBuffer.append("[").append(value).append("]").append(", ");
        }
        if (msgTemp.size() > 0) {
            anyOneNotNullFlag = false;
            msgString.append(stringBuffer.toString());
        }
        if (!notNullFlag) {
            msgString.append(propertyTemp.toString());
        }
        boolean bl = finalRes = notNullFlag && anyOneNotNullFlag;
        if (!finalRes) {
            log.info(msgString.toString());
        }
        return finalRes;
    }

    private static void dealAnyOneNotNull(Object instance, Map<String, Boolean> resultMap, Map<String, String> msgTemp, Field field, AnyOneNotNull anyOneNotNull) throws IllegalAccessException {
        String group = anyOneNotNull.group();
        if (StringUtils.isNotBlankOrNullChar(group)) {
            String newGroupStr = group.trim();
            Object fieldValue = field.get(instance);
            Boolean aBoolean = resultMap.get(newGroupStr);
            if (aBoolean == null || !aBoolean.booleanValue()) {
                if (fieldValue == null) {
                    String msg = msgTemp.get(newGroupStr);
                    if (msg == null) {
                        msgTemp.put(newGroupStr, field.getName());
                    } else {
                        msgTemp.put(newGroupStr, msg + " | " + field.getName());
                    }
                    resultMap.put(newGroupStr, false);
                } else {
                    msgTemp.remove(newGroupStr);
                    resultMap.put(newGroupStr, true);
                }
            }
        }
    }

    private static boolean dealNotNull(Class clz, Object instance, NotNull t, Field field, StringBuffer propertyTemp) throws NoSuchFieldException, IllegalAccessException {
        Object val;
        boolean flag = true;
        String condition = t.condition();
        if (StringUtils.isNotBlankOrNullChar(condition)) {
            String newConditionStr = condition.trim();
            if (newConditionStr.contains(" and ") || newConditionStr.contains(" AND ") || newConditionStr.contains(" or ") || newConditionStr.contains(" OR ")) {
                for (int i = 0; i < RELATION_TARGET_KEY.length; ++i) {
                    newConditionStr = newConditionStr.replace(RELATION_TARGET_KEY[i], RELATION_REPLACEMENT_KEY[i]);
                }
                log.debug("<\u53c2\u6570\u6821\u9a8c> \u66ff\u6362\u5927\u5199\u540e\u7684newConditionStr\uff1a{}", (Object)newConditionStr);
                if (newConditionStr.contains(AND)) {
                    String[] andArr;
                    for (String andStr : andArr = newConditionStr.split(AND)) {
                        String[] equalArr = andStr.split(EQUAL_EXPRESSION);
                        String conName = equalArr[0].trim();
                        String conValue = equalArr[1].trim();
                        Field nameField = clz.getDeclaredField(conName);
                        nameField.setAccessible(true);
                        Object fieldValue = nameField.get(instance);
                        if (conValue.equals(fieldValue)) continue;
                        if (conValue.startsWith("*")) {
                            String temp = conValue.substring(1);
                            if (String.valueOf(fieldValue).endsWith(temp)) continue;
                        }
                        flag = false;
                        break;
                    }
                } else {
                    String[] orArr = newConditionStr.split(OR);
                    for (int j = 0; j < orArr.length; ++j) {
                        String orStr = orArr[j];
                        String[] equalArr = orStr.split(EQUAL_EXPRESSION);
                        String conName = equalArr[0].trim();
                        String conValue = equalArr[1].trim();
                        Field nameField = clz.getDeclaredField(conName);
                        nameField.setAccessible(true);
                        Object fieldValue = nameField.get(instance);
                        if (!conValue.equals(fieldValue)) {
                            if (j == orArr.length - 1) {
                                flag = false;
                                continue;
                            }
                            if (!conValue.startsWith("*")) continue;
                            String temp = conValue.substring(1);
                            if (!String.valueOf(fieldValue).endsWith(temp)) {
                                continue;
                            }
                        }
                        break;
                    }
                }
            } else {
                String[] equalArr = newConditionStr.split(EQUAL_EXPRESSION);
                String conName = equalArr[0].trim();
                String conValue = equalArr[1].trim();
                Field nameField = clz.getDeclaredField(conName);
                nameField.setAccessible(true);
                Object fieldValue = nameField.get(instance);
                if (!conValue.equals(fieldValue)) {
                    if (conValue.startsWith("*")) {
                        String temp = conValue.substring(1);
                        if (!String.valueOf(fieldValue).endsWith(temp)) {
                            flag = false;
                        }
                    } else {
                        flag = false;
                    }
                }
            }
        }
        if (flag && (val = field.get(instance)) == null) {
            propertyTemp.append(field.getName() + ",");
            return false;
        }
        return true;
    }
}

