/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.utils.JsonUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class MapUtils {
    public static String toSortedUrlParam(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        TreeMap<String, Object> treeMap = null;
        treeMap = map instanceof TreeMap ? (TreeMap<String, Object>)map : new TreeMap<String, Object>(map);
        LinkedList<String> params = new LinkedList<String>();
        for (Map.Entry<String, Object> entry : treeMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                value = JsonUtils.toString(mapValue);
            }
            if (value == null || String.valueOf(value).equals("")) continue;
            params.add(entry.getKey() + "=" + value);
        }
        return String.join((CharSequence)"&", params);
    }

    public static Map<String, Object> beanToMap(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = bean.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        HashMap<String, Object> returnMap = new HashMap<String, Object>(propertyDescriptors.length);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, "");
        }
        return returnMap;
    }
}

