/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.domain.response;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import java.io.Serializable;

public class Response
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String code;
    protected String msg;

    public static void notError(Response response) {
        if (response == null) {
            throw new ResponseBodyException("500", CodeConstants.getName("500"));
        }
        if (!"200".equals(response.getCode())) {
            throw new ResponseBodyException(response.getCode(), response.getMsg());
        }
    }

    public static void notError(Response response, String msg) {
        if (response == null) {
            throw new ResponseBodyException("500", msg == null ? CodeConstants.getName("500") : msg);
        }
        if (!"200".equals(response.getCode())) {
            throw new ResponseBodyException(response.getCode(), msg == null ? response.getMsg() : msg);
        }
    }

    public static boolean isSuccess(Response response) {
        return response != null && "200".equals(response.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

