package com.icetech.common.thread;

import com.icetech.common.utils.Slf4jUtils;

public class ThreadUtils {
    public static Runnable wrapTrace(Runnable runnable) {
        String traceId = Slf4jUtils.getTraceId();
        return () -> {
            try {
                Slf4jUtils.putTraceId(traceId);
                runnable.run();
            } finally {
                Slf4jUtils.removeTraceId();
            }
        };
    }
}
