package com.icetech.common.thread;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

import com.icetech.common.utils.Slf4jUtils;
import com.icetech.common.utils.UUIDTools;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ScheduleFixTimesRunnable<T> implements Runnable {
    private final String traceId;
    private final Function<Integer, T> task;
    private final int times;
    private final Consumer<T> callback;
    private final String taskId;
    private AtomicInteger count;
    private ScheduledFuture<?> future;

    public ScheduledFuture<?> start(Supplier<ScheduledFuture<?>> supplier) {
        future = supplier.get();
        return future;
    }

    @Override
    public void run() {
        Slf4jUtils.putTraceId(traceId);
        T result = null;
        try {
            result = task.apply(count.get());
        } catch (Exception e) {
            log.error("任务执行出错|{}|{}", taskId, count, e);
        } finally {
            if (count.incrementAndGet() > times || result != null) {
                future.cancel(false);
                if (callback != null) {
                    callback.accept(result);
                }
            }
        }
    }

    public ScheduleFixTimesRunnable(String traceId, Function<Integer, T> task, int times, Consumer<T> callback) {
        this.traceId = traceId;
        this.task = task;
        this.times = times;
        this.callback = callback;
        this.taskId = UUIDTools.getUuid();
        this.count = new AtomicInteger(1);
    }
}
