package com.icetech.common.domain;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 下发请求
 * @author fangct
 */
@Data
public class SendRequest implements Serializable {
    /**
     * 车场id
     */
    @NotNull
    private Long parkId;
    /**
     * 业务类型
     */
    @NotNull
    private Integer serviceType;
    /**
     * 业务数据ID
     */
    @NotNull
    private Long serviceId;
    /**
     * 多个推送对象时需要
     */
    private String include;
    /**
     * 任务id
     */
    private Long taskId;

    private Long recordId;

    private Integer reqServiceType;
    private String topic;

    public Integer getReqServiceType(){
        if (this.reqServiceType == null){
            return this.serviceType;
        }else{
            return this.reqServiceType;
        }
    }
}
