/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.utils.Base64Tools;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSATools {
    private static final Logger log = LoggerFactory.getLogger(RSATools.class);
    public static final String SIGN_ALGORITHMS = "SHA256WithRSA";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final int MAX_ENCRYPT_BLOCK = 245;
    private static final int MAX_DECRYPT_BLOCK = 256;
    public static final String KEY_ALGORITHM = "RSA";

    public static String sign(String content, String privateKey) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64Tools.decodeBase64((String)privateKey));
            KeyFactory keyf = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(DEFAULT_CHARSET));
            byte[] signed = signature.sign();
            return Base64Tools.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean verify(String content, String sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = Base64Tools.decodeBase64((String)publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(DEFAULT_CHARSET));
            return signature.verify(Base64Tools.decodeBase64((String)sign));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = Base64Tools.decodeBase64((String)key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = Base64Tools.decodeBase64((String)key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static String getKeyString(Key key) throws Exception {
        byte[] keyBytes = key.getEncoded();
        return Base64Tools.encodeBase64String((byte[])keyBytes);
    }

    public static <T> String getSignatureContent(Map<String, T> params) {
        if (params == null) {
            return null;
        }
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (params.get(key) == null) continue;
            String value = String.valueOf(params.get(key));
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static String getListSignatureContent(List<Map> mapList) {
        if (mapList == null) {
            return null;
        }
        ArrayList<String> listStr = new ArrayList<String>();
        for (Map map : mapList) {
            listStr.add(RSATools.getSignatureContent(map));
        }
        Collections.sort(listStr);
        return ((Object)listStr).toString();
    }

    public static String encrpyt(String content, String publicKeyStr) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, RSATools.getPublicKey(publicKeyStr));
        byte[] bytes = content.getBytes(DEFAULT_CHARSET);
        int inputLen = bytes.length;
        int offSet = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 245 ? cipher.doFinal(bytes, offSet, 245) : cipher.doFinal(bytes, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 245;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return Base64Tools.encodeBase64String((byte[])encryptedData);
    }

    public static String decrypt(String content, String privateKeyStr) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, RSATools.getPrivateKey(privateKeyStr));
        byte[] bytes = Base64Tools.decodeBase64((String)content);
        int inputLen = bytes.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(bytes, offSet, 256) : cipher.doFinal(bytes, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 256;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return new String(decryptedData);
    }
}

