/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import cn.hutool.http.Header;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTools {
    private static final Logger log = LoggerFactory.getLogger(HttpTools.class);
    public static final int timeout = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String HttpClientPost(String sendurl, String data, Map<String, String> map) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(sendurl);
        if (null != map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httppost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("params", data));
        String result = "";
        try {
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(formparams, "UTF-8");
            httppost.setEntity((HttpEntity)uefEntity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String HttpClientGet(String sendurl, String data, Map<String, String> map) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String result = "";
        try {
            HttpGet httpget = null;
            httpget = null == data || "".equals(data) ? new HttpGet(sendurl) : new HttpGet(sendurl + "?" + data);
            if (null != map) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    httpget.setHeader(entry.getKey(), entry.getValue());
                }
            }
            log.info("HttpClientGet\u8bf7\u6c42\u94fe\u63a5 \uff1a" + httpget.getURI());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
                HttpEntity entity = response.getEntity();
                log.info(String.valueOf(response.getStatusLine()));
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String decodeParm(String param) throws UnsupportedEncodingException {
        param = URLDecoder.decode(param, "UTF-8");
        return param;
    }

    public static String post(String url) {
        return HttpTools.post(url, "");
    }

    public static String post(String url, String data) {
        return HttpTools.httpPost(url, data);
    }

    public static String post(String url, InputStream instream) {
        try {
            HttpEntity entity = Request.Post((String)url).bodyStream(instream, ContentType.create((String)"text/html", (Charset)Consts.UTF_8)).execute().returnResponse().getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String get(String url) {
        return HttpTools.httpGet(url);
    }

    private static String httpPost(String url, String data) {
        try {
            HttpEntity entity = Request.Post((String)url).bodyString(data, ContentType.create((String)"text/html", (Charset)Consts.UTF_8)).execute().returnResponse().getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String postFile(String url, File file) {
        return HttpTools.postFile(url, null, file);
    }

    public static String postFile(String url, String name, File file) {
        try {
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody(name, file).build();
            Request request = Request.Post((String)url);
            request.body(reqEntity);
            HttpEntity resEntity = request.execute().returnResponse().getEntity();
            return resEntity != null ? EntityUtils.toString((HttpEntity)resEntity) : null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String postJson(String url, String json) {
        try {
            String res = ((cn.hutool.http.HttpRequest)cn.hutool.http.HttpRequest.post((String)url).header(Header.CONTENT_TYPE, cn.hutool.http.ContentType.JSON.toString())).timeout(5000).body(json).execute().body();
            return res;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] getFile(String url) {
        try {
            Request request = Request.Get((String)url);
            HttpEntity resEntity = request.execute().returnResponse().getEntity();
            return EntityUtils.toByteArray((HttpEntity)resEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String httpGet(String url) {
        try {
            HttpEntity entity = Request.Get((String)url).execute().returnResponse().getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, String json) throws IllegalStateException, IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int port = uri.getPort();
        if (port == -1) {
            port = 80;
        }
        HttpHost target = new HttpHost(uri.getHost(), port);
        HttpPost request = new HttpPost(uri);
        StringEntity se = new StringEntity(json, "UTF-8");
        se.setContentType("application/json");
        request.setEntity((HttpEntity)se);
        CloseableHttpResponse response = null;
        try {
            response = client.execute(target, (HttpRequest)request);
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
                client.close();
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        StringBuilder result = new StringBuilder();
        String message = null;
        while ((message = reader.readLine()) != null) {
            result.append(message).append(System.getProperty("line.separator"));
        }
        String resultStr = result.toString();
        resultStr = resultStr.trim();
        resultStr = resultStr.replace("\n", "");
        resultStr = resultStr.replace("\r", "");
        resultStr = resultStr.replace("\t", "");
        reader.close();
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, Map<String, Object> nameValuePairs) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(url);
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        ArrayList<String> keys = new ArrayList<String>(nameValuePairs.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = nameValuePairs.get(key);
            formparams.add(new BasicNameValuePair(key, String.valueOf(value)));
        }
        String result = "";
        try {
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(formparams, "UTF-8");
            httppost.setEntity((HttpEntity)uefEntity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String getIpAddr(HttpServletRequest request) {
        try {
            String ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && (ipAddress = request.getRemoteAddr()) != null && (ipAddress.equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1"))) {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                ipAddress = inet.getHostAddress();
            }
            if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
            return ipAddress;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

