/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.thread;

import com.icetech.common.utils.Slf4jUtils;
import com.icetech.common.utils.UUIDTools;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleFixTimesRunnable<T>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ScheduleFixTimesRunnable.class);
    private final String traceId;
    private final Function<Integer, T> task;
    private final int times;
    private final Consumer<T> callback;
    private final String taskId;
    private AtomicInteger count;
    private ScheduledFuture<?> future;

    public ScheduledFuture<?> start(Supplier<ScheduledFuture<?>> supplier) {
        this.future = supplier.get();
        return this.future;
    }

    @Override
    public void run() {
        Slf4jUtils.putTraceId(this.traceId);
        Object result = null;
        try {
            result = this.task.apply(this.count.get());
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u51fa\u9519|{}|{}", new Object[]{this.taskId, this.count, e});
        }
        finally {
            if (this.count.incrementAndGet() > this.times || result != null) {
                this.future.cancel(false);
                if (this.callback != null) {
                    this.callback.accept(result);
                }
            }
        }
    }

    public ScheduleFixTimesRunnable(String traceId, Function<Integer, T> task, int times, Consumer<T> callback) {
        this.traceId = traceId;
        this.task = task;
        this.times = times;
        this.callback = callback;
        this.taskId = UUIDTools.getUuid();
        this.count = new AtomicInteger(1);
    }
}

