package com.icetech.common.utils;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @deprecated 使用 {@link ResponseUtils}
 */
@Slf4j
@Deprecated
public class ResultTools {
    /**
     * 返回
     * @deprecated 使用 {@link com.icetech.common.utils.ResponseUtils#setResponse(String, String)}
     * @return
     */
    @Deprecated
    public static String setResponse(String code, String msg) {
        Response response = new Response();
        response.setCode(code);
        response.setMsg(msg);
        return JsonUtils.toString(response);
    }

    /**
     * 返回
     * @deprecated 使用 {@link com.icetech.common.utils.ResponseUtils#setNullMsgResponse(String)}
     * @return
     */
    @Deprecated
    public static String setNullMsgResponse(String code) {
        Response response = new Response();
        response.setCode(code);
        return JsonUtils.toString(response);
    }

    /**
     * @deprecated 使用 {@link com.icetech.common.utils.ResponseUtils#setResponse(String, String, Object)}
     * @param code
     * @param data
     * @return
     */
    @Deprecated
    public static <T> String setResponse(String code, String msg, T data) {

        ObjectResponse response = new ObjectResponse(code, msg, data);
        return JsonUtils.toString(response);
    }

    /**
     * 将响应结果中的data部分转换成指定类型后返回
     * @deprecated 使用 {@link com.icetech.common.utils.ResponseUtils#getObjectResponse(String, Class)}
     *
     * @param responseResult
     * @param clazz
     * @return
     */
    @Deprecated
    public static ObjectResponse getObjectResponse(String responseResult, Class clazz) {
        ObjectResponse objectResponse = getObjectResponse(responseResult);
        if (objectResponse == null) {
            return null;
        }
        Object data = objectResponse.getData();
        if (data != null) {
            String dataJson = JsonUtils.toString(data);
            log.info("***data结果为: {}", dataJson);
            objectResponse.setData(JsonUtils.parseObject(dataJson, clazz));
        }
        return objectResponse;
    }

    /**
     * 将响应结果中的data列表部分转换成指定类型后返回
     * @deprecated 使用 {@link com.icetech.common.utils.ResponseUtils#getListObjectResponse(String, Class)}
     *
     * @param responseResult
     * @param cla
     * @return
     */
    @Deprecated
    public static <T> ObjectResponse getObjectListResponse(String responseResult, Class<T> cla) {
        ObjectResponse objectResponse = getObjectResponse(responseResult);
        if (objectResponse == null) {
            return null;
        }
        Object data = objectResponse.getData();
        if (data != null) {
            String dataJson = JsonUtils.toString(data);
            log.info("***data结果为: {}", dataJson);
            objectResponse.setData(JsonUtils.parseArray(dataJson, cla));
        }
        return objectResponse;
    }

    /**
     * 判断响应的json结果，code码是否成功
     * @deprecated 使用 {@link com.icetech.common.utils.ResponseUtils#isSuccess(String)}
     *
     * @param responseBody
     * @return
     */
    @Deprecated
    public static boolean isSuccess(String responseBody) {
        ObjectResponse objectResponse = getObjectResponse(responseBody);
        if (objectResponse != null && CodeConstants.SUCCESS.equals(objectResponse.getCode())) {
            return true;
        }
        log.info("***响应结果：{}", responseBody);
        return false;
    }

    /**
     * @deprecated 使用 {@link ObjectResponse#isSuccess(Response)}
     *
     * @return
     */
    @Deprecated
    public static boolean isSuccess(ObjectResponse objectResponse) {
        if (objectResponse != null && CodeConstants.SUCCESS.equals(objectResponse.getCode())) {
            return true;
        }
        return false;
    }

    /**
     * 返回正确的结果
     * @deprecated 使用 {@link ObjectResponse#success(Object)}
     *
     * @return
     */
    @Deprecated
    public static ObjectResponse success(Object data) {
        ObjectResponse objectResponse = new ObjectResponse();
        objectResponse.setData(data);
        objectResponse.setCode(CodeConstantsEnum.SUCCESS.getCode());
        objectResponse.setMsg(CodeConstantsEnum.SUCCESS.getDesc());
        return objectResponse;
    }

    /**
     * 返回正确的结果
     * @deprecated 使用 {@link ObjectResponse#success()}
     *
     * @return
     */
    @Deprecated
    public static ObjectResponse success() {
        ObjectResponse objectResponse = new ObjectResponse();
        objectResponse.setCode(CodeConstantsEnum.SUCCESS.getCode());
        objectResponse.setMsg(CodeConstantsEnum.SUCCESS.getDesc());
        return objectResponse;
    }

    /**
     * 返回正确的结果
     * @deprecated 使用 {@link ObjectResponse#failed(String, String)}
     *
     * @return
     */
    @Deprecated
    public static ObjectResponse fail(String code, String desc) {
        ObjectResponse objectResponse = new ObjectResponse();
        objectResponse.setCode(code);
        objectResponse.setMsg(desc);
        return objectResponse;
    }

    /**
     * 返回正确的结果
     * @deprecated 使用 {@link ObjectResponse#failed(CodeConstantsEnum)}
     *
     * @return
     */
    @Deprecated
    public static ObjectResponse fail(CodeConstantsEnum code) {
        ObjectResponse objectResponse = new ObjectResponse();
        objectResponse.setCode(code.getCode());
        objectResponse.setMsg(code.getDesc());
        return objectResponse;
    }

    /**
     * 返回正确的结果
     * @deprecated 使用 {@link ObjectResponse#instance(String, String, Object)}
     *
     * @return
     */
    @Deprecated
    public static ObjectResponse getResponse(String code, String desc, Object data) {
        ObjectResponse objectResponse = new ObjectResponse();
        objectResponse.setCode(code);
        objectResponse.setData(data);
        objectResponse.setMsg(desc);
        return objectResponse;
    }

    @Deprecated
    public static <T> ObjectResponse<Page<T>> getPageResponse(List<T> rows, Long total, Integer totalPage) {
        ObjectResponse<Page<T>> objectResponse = new ObjectResponse<>();
        Page<T> page = new Page<>();
        page.setRows(rows);
        page.setTotal(total);
        page.setTotalPage(totalPage);
        objectResponse.setCode(CodeConstantsEnum.SUCCESS.getCode());
        objectResponse.setMsg(CodeConstantsEnum.SUCCESS.getDesc());
        objectResponse.setData(page);
        return objectResponse;
    }

    /**
     * 将响应结果转换为ObjectResponse对象
     * @deprecated 使用 {@link ResponseUtils#getObjectResponse(String)}
     * @param responseBody
     * @return
     */
    @Deprecated
    public static ObjectResponse getObjectResponse(String responseBody) {
        if (StringUtils.isBlank(responseBody)) {
            return null;
        }
        try {
            ObjectResponse response = JsonUtils.parseObject(responseBody, ObjectResponse.class);
            if (response != null) {
                return response;
            } else {
                log.info("***responseBody不能转换为ObjectResponse对象，{}", responseBody);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            log.error("***转换为ObjectResponse对象异常，参数:{}，error:{}", responseBody, e.getMessage());
        }
        return null;
    }
}
