package com.icetech.common.utils;

import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 同步锁池
 * @author fangct
 */
@Slf4j
public class LockPoolUtils {

    /**
     * 锁池
     */
    private static Map<String, String> LOCK_POOL = new ConcurrentHashMap<>();

    /**
     * 获取锁对象，同时删除锁
     * @param lockKey 关键字
     * @return 锁对象
     */
    public static String getLock(String lockKey) {
        if (LOCK_POOL.size() > 500) {
            log.warn("[监控埋点] 锁池map大小已超过500，请及时处理");
        }
        return LOCK_POOL.remove(lockKey);
    }

    /**
     * 添加锁
     * @param lockKey 关键字
     * @return 旧锁
     */
    public static String add(String lockKey) {
        return LOCK_POOL.put(lockKey, lockKey);
    }

    /**
     * 删除锁
     * @param lockKey 关键字
     * @return 锁
     */
    public static String remove(String lockKey) {
        return LOCK_POOL.remove(lockKey);
    }
}
