package com.icetech.common.exception;

import java.io.Serializable;

/**
 * description: 返回ResponseBody时出现异常
 * @author fangct
 * @since 1.0
 */
public class ResponseBodyException extends RuntimeException
        implements Serializable {

    private String errCode;

    private String icon;

    /**
     * 是否国际化
     */
    private Boolean i18n = true;

    public ResponseBodyException(String errCode, String message) {
        super(message);
        this.errCode = errCode;
    }

    public ResponseBodyException(String errCode, String message, Boolean i18n) {
        super(message);
        this.errCode = errCode;
        this.i18n = i18n;
    }

    public ResponseBodyException(String errCode, String message, String icon) {
        super(message);
        this.errCode = errCode;
        this.icon = icon;
    }

    public ResponseBodyException(String errCode, String message, Throwable e) {
        super(message, e);
        this.errCode = errCode;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public String getErrCode() {
        return this.errCode;
    }
    
    public Boolean getI18n() {
        return i18n;
    }

    public void setI18n(Boolean i18n) {
        this.i18n = i18n;
    }

    @Override
    public String toString() {
        return super.toString();
    }

}
