package com.icetech.common.constants;

/**
 * redis key声明
 * @author fangct
 */
public class RedisKeyConstants {
    /**
     * socketMsgTopic
     */
    public static String SOCKET_MSG_TOPIC = "ice-proxy-receive";
    
    /**
     * mq记录的参数前缀
     */
    public static final String MQ_RECORD_PREFIX = "MQ_RECORD_";

    /**
     * 数据库无数据对应缓存值
     */
    public static final String NONE_VALUE = "$NONE$";

    public static final String KEY_PREFIX_GRAY = "gray:";

    // ---------- 车场信息缓存 ---------- // ice_park
    public static final long EXPIRE_PARK_INFO = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_PARK_CODE = "park:info:code:";    // park_code
    public static final String KEY_PREFIX_PARK_ID = "park:info:id:";    // park_id

    // ---------- 车场配置缓存 ---------- // ice_park_config
    public static final long EXPIRE_PARK_CONFIG = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_PARK_CONFIG_PARK = "park:config:park:id:";    // park_id
    public static final String KEY_PREFIX_PARK_CONFIG_PARK_CODE = "park:config:park:code:";    // park_code

    // ---------- 车场通道缓存 ---------- // ice_park_inoutdevice
    public static final long EXPIRE_PARK_CHANNEL = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_PARK_CHANNEL = "park:channel:id:";   // channel_id
    public static final String KEY_PREFIX_PARK_CHANNEL_CODE = "park:channel:code:";   // channel_code

    // ---------- 车场设备缓存 ---------- // ice_park_device
    public static final long EXPIRE_PARK_DEVICE = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER = "park:device:serial_number:";   // serial_number

    // ---------- 遥控器缓存 ----------  // ice_park_remoteconfig
    public static final long EXPIRE_PARK_REMOTE_CONFIG = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_PARK_REMOTE_CONFIG_PARK = "park:remote_config:park:"; // park_id

    // ---------- LCD显示缓存 ----------    // ice_lcd_show
    public static final long EXPIRE_LCD_SHOW = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LCD_SHOW_PARK = "lcd:show:park:"; // park_id
    public static final String KEY_PREFIX_LCD_SHOW_CHANNEL = "lcd:show:channel:"; // channel_id
    public static final String KEY_LCD_SHOW_PARK_DEFAULT = "lcd:show:park:default";

    // ---------- LCD配置缓存 ----------    // ice_lcd_config
    public static final long EXPIRE_LCD_CONFIG = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LCD_CONFIG_PARK = "lcd:config:park:"; // park_id
    public static final String KEY_PREFIX_LCD_CONFIG_CHANNEL = "lcd:config:channel:"; // channel_id
    public static final String KEY_LCD_CONFIG_PARK_DEFAULT = "lcd:config:park:default";

    // ---------- LCD配置缓存 ----------    // ice_lcd_tips
    public static final long EXPIRE_LCD_TIPS = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LCD_TIPS_PARK = "lcd:tips:park:"; // park_id
    public static final String KEY_PREFIX_LCD_TIPS_CHANNEL = "lcd:tips:channel:"; // channel_id
    public static final String KEY_LCD_TIPS_PARK_DEFAULT = "lcd:tips:park:default";

    // ---------- LCD声音缓存 ----------    // ice_lcd_sound
    public static final long EXPIRE_LCD_SOUND = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LCD_SOUND_PARK = "lcd:sound:park:";   // park_id
    public static final String KEY_PREFIX_LCD_SOUND_CHANNEL = "lcd:sound:channel:"; // channel_id
    public static final String KEY_LCD_SOUND_PARK_DEFAULT = "lcd:sound:park:default";

    // ---------- LCD声音编码缓存 ----------    // ice_lcd_soundcode
    public static final long EXPIRE_LCD_SOUND_CODE = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_LCD_SOUND_CODE_DEFAULT = "lcd:sound:code:default";

    // ---------- LED配置缓存 ---------- // ice_ledsound_config、ice_led_config
    public static final long EXPIRE_LED_CONFIG = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LED_CONFIG_PARK = "led:config:park:";   // park_id
    public static final String KEY_PREFIX_LED_CONFIG_CHANNEL = "led:config:channel:"; // channel_id
    public static final String KEY_LED_CONFIG_PARK_DEFAULT = "led:config:park:default";

    // ---------- LED显示缓存 ----------    // ice_led、ice_led_show
    public static final long EXPIRE_LED_SHOW = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LED_SHOW_PARK = "led:show:park:"; // park_id
    public static final String KEY_PREFIX_LED_SHOW_CHANNEL = "led:show:channel:"; // channel_id
    public static final String KEY_LED_SHOW_PARK_DEFAULT = "led:show:park:default";

    // ---------- LED声音缓存 ---------- // ice_sound、ice_led_sound
    public static final long EXPIRE_LED_SOUND = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LED_SOUND_PARK = "led:sound:park:";   // park_id
    public static final String KEY_PREFIX_LED_SOUND_CHANNEL = "led:sound:channel:"; // channel_id
    public static final String KEY_LED_SOUND_PARK_DEFAULT = "led:sound:park:default";

    // ---------- LED 配置缓存 ----------  // ice_special_led、ice_led_tips
    public static final long EXPIRE_LED_TIPS = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_LED_TIPS_PARK = "led:tips:park:"; // park_id
    public static final String KEY_PREFIX_LED_TIPS_CHANNEL = "led:tips:channel:"; // channel_id
    public static final String KEY_LED_TIPS_PARK_DEFAULT = "led:tips:park:default";

    // ---------- 车场计费规则配置缓存 ---------- // ice_park_chargeconfig
    public static final long EXPIRE_CHARGE_PARK = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_CHARGE_PARK = "charge:park:"; // park_id

    // ---------- 车场区域计费规则配置缓存 ----------   // ice_region_chargeconfig
    public static final long EXPIRE_CHARGE_REGION = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_CHARGE_REGION_PARK = "charge:region:park:";    // park_id

    // ---------- 车场通用计费规则配置缓存 ----------   // ice_charge_naturalday、ice_charge_once、ice_charge_dyration
    public static final long EXPIRE_CHARGE_NATURAL = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_CHARGE_NATURAL_CODE = "charge:natural:code:"; // bill_type_code

    // ---------- 车场按天计费规则配置缓存 ----------   // ice_charge_daynight、ice_charge_once、ice_charge_dyration
    public static final long EXPIRE_CHARGE_DAY_NIGHT = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_CHARGE_DAY_NIGHT_CODE = "charge:day_night:code:"; // bill_type_code

    // ---------- 车场24H计费规则配置缓存 ----------  // ice_charge_24charge、ice_charge_24charge_set
    public static final long EXPIRE_CHARGE_24HOUR = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_CHARGE_24HOUR_CODE = "charge:24hour:code:";   // bill_type_code

    // ---------- 产品型号信息缓存 ----------  // ice_produce_model
    public static final long EXPIRE_PRODUCE_MODEL = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_PRODUCE_MODEL = "produce:model";

    // ---------- 用户权限下的车场列表 ----------  //
    @Deprecated
    public static final long EXPIRE_USER_INST_PARKS = 7 * 24 * 60 * 60 * 1000;
    @Deprecated
    public static final String KEY_PREFIX_USER_INST_PARKS = "user:inst-park:";
    public static final long EXPIRE_USER_PARKS = 7 * 24 * 60 * 60 * 1000;
    public static final String KEY_PREFIX_USER_PARKS = "user:park:";
}
