package com.icetech.common.constants;

import lombok.Getter;

/**
 * 下次触发时间的间隔频率
 * 71小时36分钟44秒以内完成13次通知
 */
public enum NextFireTimeEnum {

    ONCE(1, 4),//4秒
    TWICE(2, 10),//10秒
    THIRD(3, 30),//30秒
    FOURTH(4, 600),//10分钟
    FIFTH(5, 1800),//30分钟
    SIXTH(6, 3600),//1小时
    SEVENTH(7, 7200),//2小时
    EIGHTH(8, 3600 * 6),//6小时
    NINTH(9, 3600 * 12),//12小时
    TENTH(10, 3600 * 12),//12小时
    ELEVENTH(11, 3600 * 12),//12小时
    TWELFTH(12, 3600 * 12),//12小时
    THIRTEENTH(13, 3600 * 12),//12小时
    ;

    @Getter
    private final Integer interval;
    @Getter
    private final Integer cs;

    NextFireTimeEnum(Integer cs, Integer interval) {
        this.cs = cs;
        this.interval = interval;
    }

    public static Integer getInterval(Integer cs) {
        for (NextFireTimeEnum item : NextFireTimeEnum.values()) {
            if (item.getCs().equals(cs)) {
                return item.getInterval();
            }
        }
        return 3600 * 12;
    }

}
