package com.icetech.p2p.enums;

/**
 * Description PlayTypeEnums
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/6 11:05 上午
 */
public enum PlayLicenseTypeEnums {

    /**
     *只在固定池播放
     */
    FIXED(1, "只在固定池播放"),

    /**
     *优先固定池
     */
    PRIORITY_FIXED(2, "优先固定池"),
    
    /**
     * 只在随机池
     */
    RANDOM(3, "只在随机池"),
    ;

    private Integer code;
    private String msg;

    PlayLicenseTypeEnums(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static PlayLicenseTypeEnums getTypeEnumByCode(Integer code) {
        for (PlayLicenseTypeEnums skipTypeEnum : PlayLicenseTypeEnums.values()) {
            if (skipTypeEnum.getCode().equals(code)) {
                return skipTypeEnum;
            }
        }
        return null;
    }
}
