package com.icetech.p2p.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.p2p.vo.UpgradeApiRequest;

/**
 * Description DeviceBaseApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @Date 2022/9/8
 */
public interface DeviceOperateApi {

    /**
     * 升级设备
     * @param request 参数
     * @return taskId
     */
    ObjectResponse<String> upgrade(UpgradeApiRequest request);

    /**
     * 开关闸下发
     * @param serialNumber 设备SN
     * @param switchType 开关闸类型
     * @return
     */
    ObjectResponse<String> remoteSwitch(String serialNumber, int switchType);

    /**
     * 远程设备指令下发
     * @param cmdFlag 下发指令 0-关闭 1=启动
     * @param sn sn
     * @return 结果
     */
    ObjectResponse<String> remoteCmd(Integer cmdFlag, String sn);
    /**
     * 通用下发
     * @param cmd 下发接口名
     * @param requestParam 参数
     * @return 下发的消息id，作为查询下发结果的唯一标识
     */
    <T> ObjectResponse<String> commonDown(String sn, String cmd, T requestParam);

    /**
     * 查询下发消息的处理结果
     * @param msgId 消息ID
     * @return
     */
    ObjectResponse<Object> queryDownResult(String msgId);
}
