package com.icetech.p2p.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.p2p.vo.LicenseAuthVO;
import com.icetech.p2p.vo.SyncProductInfoRequest;

/**
 * Description DeviceLicenseApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/6 18:33
 */
public interface DeviceLicenseApi {
    
    /**
     * Description: 获取视频地址（无限制）
     * Version1.0 2022-04-07 by wgy 创建
     * 
     * @param clientAgent   客户端来源, 1-html,2-hls
     * @param sn            设备sn
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.p2p.vo.LicenseAuthVO>       
     */
    ObjectResponse<LicenseAuthVO> videoUrl(Integer clientAgent, String sn);
    
    /**
     * Description: license 释放（停止播放）
     * Version1.0 2022-04-07 by wgy 创建
     * 
     * @param sn        sn号
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Void>
     */
    ObjectResponse<Void> licenseRelease(String sn);

    /**
     * 同步套餐信息
     * @param syncProductInfoRequest 套餐信息
     * @return 成功/失败
     */
    ObjectResponse<Void> syncProductInfo(SyncProductInfoRequest syncProductInfoRequest);

    /**
     * 打开视频
     * @param productId 套餐ID
     * @param clientAgent 客户端
     * @param sn 设备序列号
     * @return 播放参数
     */
    ObjectResponse<LicenseAuthVO> applyPlayVideo(Long productId, Integer clientAgent, String sn);

    /**
     * 关闭视频窗口
     * @param productId 套餐id
     * @param sn 序列号
     * @return 成功/失败
     */
    ObjectResponse<Void> closeVideo(Long productId, String sn);

    /**
     * 强制断开视频
     * @param sn 设备序列号
     * @param productId 套餐ID
     * @return 结果
     */
    ObjectResponse<Void> forcedDisconnect(String sn, Long productId);
}
