package com.icetech.p2p.api;

import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.p2p.model.IceDeviceFile;

/**
 * Description DeviceFileApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/10/16 16:47
 */
public interface DeviceFileApi {

    /**
     * Description: 设备日志记录
     * Version1.0 2023-10-16 by wgy 创建
     *
     * @param serialNumber 设备编号
     * @param beginTime    开始时间
     * @param endTime      结束时间
     * @param pageNo       页码
     * @param pageSize     页数
     * @return IceDeviceOffline
     */
    ObjectResponse<Page<IceDeviceFile>> getDeviceFile(String serialNumber, String beginTime, String endTime, Integer pageNo, Integer pageSize);

    /**
     * Description: 请求相机实时日志
     *
     * @param serialNumber  sn
     * @return msgId
     */
    ObjectResponse<String> getDeviceNowLog(String serialNumber);

    /**
     * Description: 获取设备日志文件路径
     *
     * @param fileId    文件id
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.String>
     */
    ObjectResponse<String> getDeviceFilePath(Integer fileId);
}
