/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.domain.entity.dto;

import com.icetech.city.road.domain.constant.CardTypeConstant;
import com.icetech.city.road.domain.entity.dto.MonthCardDto;
import com.icetech.city.road.domain.entity.dto.MonthInfoDto;
import com.icetech.city.road.domain.entity.dto.SpecCarInfoDto;
import com.icetech.city.road.domain.table.MonthInfo;
import com.icetech.city.road.domain.table.MonthProduct;
import com.icetech.city.road.domain.table.VipPlate;
import lombok.Generated;

public class CardTypeDto {
    protected Integer cardType;
    protected MonthCardDto monthCard;
    protected VipPlate vipPlate;
    protected SpecCarInfoDto specCar;

    public CardTypeDto(int type) {
        this.cardType = type;
    }

    public static CardTypeDto ofTempCar() {
        return new CardTypeDto(CardTypeConstant.TEMP);
    }

    public static CardTypeDto ofMonthCar(MonthCardDto dto) {
        return new CardTypeDto(CardTypeConstant.MONTH).setMonthCard(dto);
    }

    public static CardTypeDto ofMonthCar(MonthInfoDto dto) {
        return new CardTypeDto(CardTypeConstant.MONTH).setMonthCard(new MonthCardDto(dto));
    }

    public static CardTypeDto ofMonthCar(MonthProduct product, MonthInfo info) {
        return new CardTypeDto(CardTypeConstant.MONTH).setMonthCard(new MonthCardDto(product, info));
    }

    public static CardTypeDto ofVipCar(VipPlate vipPlate) {
        return new CardTypeDto(CardTypeConstant.VIP).setVipPlate(vipPlate);
    }

    public static CardTypeDto ofSpecCar(SpecCarInfoDto specCar) {
        return new CardTypeDto(CardTypeConstant.SPEC).setSpecCar(specCar);
    }

    public static CardTypeDto ofWhite() {
        return new CardTypeDto(CardTypeConstant.WHITELIST);
    }

    public static CardTypeDto ofBlack() {
        return new CardTypeDto(CardTypeConstant.BLACKLIST);
    }

    public static CardTypeDto ofNonVehicle() {
        return new CardTypeDto(CardTypeConstant.NON_VEHICLE);
    }

    @Generated
    public Integer getCardType() {
        return this.cardType;
    }

    @Generated
    public MonthCardDto getMonthCard() {
        return this.monthCard;
    }

    @Generated
    public VipPlate getVipPlate() {
        return this.vipPlate;
    }

    @Generated
    public SpecCarInfoDto getSpecCar() {
        return this.specCar;
    }

    @Generated
    public CardTypeDto setCardType(Integer cardType) {
        this.cardType = cardType;
        return this;
    }

    @Generated
    public CardTypeDto setMonthCard(MonthCardDto monthCard) {
        this.monthCard = monthCard;
        return this;
    }

    @Generated
    public CardTypeDto setVipPlate(VipPlate vipPlate) {
        this.vipPlate = vipPlate;
        return this;
    }

    @Generated
    public CardTypeDto setSpecCar(SpecCarInfoDto specCar) {
        this.specCar = specCar;
        return this;
    }

    @Generated
    public String toString() {
        return "CardTypeDto(cardType=" + this.getCardType() + ", monthCard=" + this.getMonthCard() + ", vipPlate=" + this.getVipPlate() + ", specCar=" + this.getSpecCar() + ")";
    }

    @Generated
    public CardTypeDto() {
    }

    @Generated
    public CardTypeDto(Integer cardType, MonthCardDto monthCard, VipPlate vipPlate, SpecCarInfoDto specCar) {
        this.cardType = cardType;
        this.monthCard = monthCard;
        this.vipPlate = vipPlate;
        this.specCar = specCar;
    }
}

