package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_pos_order_reg_aggr")
public class PosOrderRegAggr implements Serializable {
    /** ID */
    @TableField("id")
    protected Long id;
    /** 车场ID */
    @TableField("park_id")
    protected Long parkId;
    /** 员工ID */
    @TableField("empe_id")
    protected Long empeId;
    /** 车位号 */
    @TableField("aggr_date")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate aggrDate;
    /** 车位号 */
    @TableField("order_count")
    protected Long orderCount;
    /** 车位号 */
    @TableField("reg_count")
    protected Long regCount;
    /** 车位号 */
    @TableField("reg_timely_count")
    protected Long regTimelyCount;
    /** 车位号 */
    @TableField("unreg_inpark_count")
    protected Long unregInparkCount;
    /** 车位号 */
    @TableField("unreg_leave_count")
    protected Long unregLeaveCount;
    /** 登记率 */
    @TableField("reg_rate")
    protected BigDecimal regRate;
    /** 登记及时率 */
    @TableField("reg_timely_rate")
    protected BigDecimal regTimelyRate;
    /** 创建时间 */
    @TableField("create_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
}
