package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_pos_order_reg")
public class PosOrderReg implements Serializable {
    /** ID */
    @TableField("id")
    protected Long id;
    /** 车场ID */
    @TableField("park_id")
    protected Long parkId;
    /** 员工ID */
    @TableField("empe_id")
    protected Long empeId;
    /** 车位号 */
    @TableField("berth_code")
    protected String berthCode;
    /** 车牌号 */
    @TableField("plate_num")
    protected String plateNum;
    /** 订单号 */
    @TableField("order_num")
    protected String orderNum;
    /** 检测时间 */
    @TableField(value = "detect_time", updateStrategy = FieldStrategy.NEVER)
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime detectTime;
    /** 登记时间 */
    @TableField("register_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime registerTime;
    /** 误差时长(秒) */
    @TableField("offset_duration")
    protected Integer offsetDuration;
    /** 登记结果(0-未登记; 1-正常; 2-延迟; ) */
    @TableField("register_result")
    protected Integer registerResult;
    /** 创建时间 */
    @TableField(value = "create_time", updateStrategy = FieldStrategy.NEVER)
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
}
