package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 道路系统配置表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_park_config")
public class ParkConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * 免费时长是否计入停车费用（1：是 2：否 默认为2）
     */
    private Integer freetimeStatus;

    /**
     * 计费精度（0：分钟，1：秒 默认0）
     */
    private Integer billPrecision;

    /**
     * 是否补时（1：是，2：否，默认为1）
     */
    private Integer isFilltime;

    /**
     * 缴费后离场预留免费时长(单位分钟)
     */
    private Integer isfreeAfterpay;

    /**
     * 超时计费起始时间（1：末次缴费时间，2：车辆入场时间，默认为1）
     */
    private Integer overtimeBillType;

    /**
     * 是否允许二次使用免费时长（1：不允许，2：允许，默认为1）
     */
    private Integer isallowfreetmonce;

    /**
     * 收费是否抹零头1是2否 默认为1
     */
    private Integer isnotgetsmallchange;

    /**
     * 是否支持电子支付（0：不支持，1：支持，默认为1）
     */
    private Boolean isEpayment;

    /**
     * 聚合支付支付类型 1:直连支付，2：间联支付，3：兴业银行， 农发行 ;5宁波银行
     */
    private Integer epayment;

    /**
     * 是否支持无感支付（0：不支持，1：支持，默认为1）
     */
    private Boolean isNosenpayment;

    /**
     * 无感支付支付类型
     */
    private Integer nosenpayment;

    /**
     * 开电子发票（1：是，2：否，默认为2）
     */
    private Integer isInvoice;

    /**
     * 默认1
     */
    private Integer switchType;

    /**
     * 计费规则版本编号，默认为0
     */
    private Integer chargeVersionNum;
    /**
     * 是否支持ETC支付
     */
    private Boolean etcPay;
    /**
     * ETC厂商标识
     */
    private Integer etcDevModel;
    /**
     * 是否开启自动离场
     */
    private Boolean autoLeave;
    /**
     * 自动离场时间
     */
    private Integer autoLeaveTimer;

    /** 违停配置类型(0-无;1-时长;2-时段) */
    protected Integer illegalParkingType;
    /** 违停时长配置(分钟, 违停配置类型为1时必填) */
    protected Long illegalParkingDuration;
    /** 违停时段配置-开始(违停配置类型为2时必填) */
    protected LocalTime illegalParkingStart;
    /** 违停时段配置-结束(违停配置类型为2时必填) */
    protected LocalTime illegalParkingStop;
    /** 车辆更新模式(0-关闭;1-直接更新;2-生成新订单) */
    protected Integer carUpdateMode;
    /** 是否支持车辆自助离场 */
    protected Integer vehSelfExit;
    /** 有效订单时长(单位秒) */
    protected Integer validOrderDuration;

    /** 是否启用节假日计费 默认0,0否，1是 */
    protected Integer holidayType;
    /** 节假日计费规则（存储计费规则编号） */
    protected String holidayDayBillcode;
    /** 是否包含周六日,0不包含 1,包含 默认0 */
    protected Integer isIncludeWeekends;
    /** 新能源车节假日计费规则（存储计费规则编号） */
    protected String newenergyDayBillcode;
    /** 是否包含周六日,0不包含 1,包含 默认0 */
    protected Integer isNewenergyIncludeWeekends;

    /**
     * 大额订单阈值
     */
    private BigDecimal orderBigAmt;

    /**
     * 是否开启大额订单追缴 0：不开启，1：开启
     */
    private Integer isOrderBigAmt;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;
}
