package com.icetech.city.road.domain.table;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 订单欠费统计
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_order_unpaid_aggr")
public class OrderUnpaidAggr implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /**
     * 车牌号
     */
    protected String plateNum;
    /**
     * 欠费条数
     */
    protected Long unpaidCount;
    /**
     * 订单金额
     */
    protected Double sumTotalPrice;
    /**
     * 已缴金额
     */
    protected Double sumPaidPrice;
    /**
     * 待缴金额
     */
    protected Double sumUnpaidPrice;
    /**
     * 优惠金额
     */
    protected Double sumDiscountPrice;
    /**
     * 退款金额
     */
    protected Double sumRefundPrice;
}
