package com.icetech.city.road.domain.table;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * 节假日表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-08-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_holidays")
public class Holidays implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 节假日名称
     */
    private String name;

    /**
     * 假期开始时间
     */
    private Date startDate;

    /**
     * 假期结束时间
     */
    private Date endDate;

    /**
     * 调休上班日期1
     */
    private Date workingDate1;

    /**
     * 调休上班日期2
     */
    private Date workingDate2;

    /**
     * 状态1正常2禁用
     */
    private Integer isStatus;

    /**
     * 是否删除（0正常、1删除）
     */
    private Boolean isDelete;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    public Date getStartDate() {
        if (Objects.isNull(startDate)){
            return null;
        }
        return DateUtil.beginOfDay(startDate);
    }

    public Date getEndDate() {
        if (Objects.isNull(endDate)){
            return null;
        }
        return DateUtil.endOfDay(endDate);
    }


}
