package com.icetech.city.road.domain.table;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 审核记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-06-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_etc_pay_record")
public class EtcPayRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * ETC 扣款的订单编号
     */
    private String orderNum;
    /**
     * 交易金额
     */
    private BigDecimal fee;
    /**
     * 泊位号
     */
    private Integer berthId;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 进场时间
     */
    private Long enterTime;
    /**
     * 离场时间
     */
    private Long exitTime;
    /**
     * 请求扣费时间
     */
    private Long sendPayTime;
    /**
     * 扣费状态  1=未发送 2=成功 3=失败
     */
    private Integer sendPayStatus;
    /**
     * 撤销时间
     */
    private Long cancelTime;
    /**
     * 撤销状态 1=未撤销 2=成功 3=失败
     */
    private Integer cancelStatus;
    /**
     * 通知时间
     */
    private Long notifyTime;
    /**
     * 通知状态 1=未通知 2=成功 3=失败
     */
    private Integer notifyStatus;
    /**
     * 确认时间
     */
    private Long confirmTime;
    /**
     * 确认状态 1=未确认 2=成功 3=失败
     */
    private Integer confirmStatus;
    /**
     * 最终付款状态 0=未支付 1=已支付
     */
    private Boolean payStatus;

    private Date createTime;

    private String adder;

    private Date updateTime;

    private String updateUser;

    private String remark;


    /**
     * 车场编号
     */
    @TableField(exist = false)
    private String parkCode;
    /**
     * 车场名称
     */
    @TableField(exist = false)
    private String parkName;
    /**
     * 泊位编号
     */
    @TableField(exist = false)
    private String berthCode;

    /**
     * 停车时长
     */
    @TableField(exist = false)
    private Integer parkTime;


}
