package com.icetech.city.road.domain.entity.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class MonthOrderDto implements Serializable {
    private Long id;

    private Integer parkId;

    private String parkCode;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 区域名称
     */
    private String regionName;
    /**
     * 车牌号
     */
    private String plateNumber;
    /**
     * 车主姓名
     */
    private String cardOwner;
    /**
     * 月卡产品名称
     */
    private String productName;
    /**
     * 产品id
     */
    private Integer productId;
    /**
     * 套餐所售金额
     */
    private String paymoney;
    /**
     * 产品面额（1个月2个月等）
     */
    private int duration;
    /**
     * 车位数
     */
    private int plotCount;
    /**
     * 购买数量
     */
    private int count;
    /**
     * 月卡开始时间
     */
    private Date startTime;
    /**
     * 月卡结束时间
     */
    private Date endTime;
    /**
     * 续费时间
     */
    private String remark;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 操作类型1 新增 2 续费
     */
    protected Integer cardOpertype;
    /**
     * 操作人
     */
    protected String operAccount;
    /**
     * 操作时间
     */
    protected Date operTime;

    /**
     * 月卡状态 1 生效中 2 待生效 3 已退费 4 已过期 5 冻结 6暂停 98 审核中 99 已驳回
     */
    private Integer cardStatus;
    /**
     * 支付渠道
     */
    private int payChannel;
    /**
     * 支付方式
     */
    private int payMethod;

    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 支付金额
     */
    private String totalPrice;
    /**
     * 操作记录id
     */
    private Integer monthRecordId;
    /**
     * 交易流水号
     */
    private String tradeNo;
}
