package com.icetech.city.road.domain.entity.dto;

import com.icetech.city.road.domain.constant.CardTypeConstant;
import com.icetech.city.road.domain.table.MonthInfo;
import com.icetech.city.road.domain.table.MonthProduct;
import com.icetech.city.road.domain.table.VipPlate;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class CardTypeDto {
    protected Integer cardType;
    protected MonthCardDto monthCard;
    protected VipPlate vipPlate;
    protected SpecCarInfoDto specCar;

    public CardTypeDto(int type) {
        this.cardType = type;
    }

    public static CardTypeDto ofTempCar() {
        return new CardTypeDto(CardTypeConstant.TEMP);
    }

    public static CardTypeDto ofMonthCar(MonthCardDto dto) {
        return new CardTypeDto(CardTypeConstant.MONTH)
                .setMonthCard(dto);
    }

    public static CardTypeDto ofMonthCar(MonthInfoDto dto) {
        return new CardTypeDto(CardTypeConstant.MONTH)
                .setMonthCard(new MonthCardDto(dto));
    }

    public static CardTypeDto ofMonthCar(MonthProduct product, MonthInfo info) {
        return new CardTypeDto(CardTypeConstant.MONTH)
                .setMonthCard(new MonthCardDto(product, info));
    }

    public static CardTypeDto ofVipCar(VipPlate vipPlate) {
        return new CardTypeDto(CardTypeConstant.VIP)
                .setVipPlate(vipPlate);
    }

    public static CardTypeDto ofSpecCar(SpecCarInfoDto specCar) {
        return new CardTypeDto(CardTypeConstant.SPEC)
                .setSpecCar(specCar);
    }

    public static CardTypeDto ofWhite() {
        return new CardTypeDto(CardTypeConstant.WHITELIST);
    }

    public static CardTypeDto ofBlack() {
        return new CardTypeDto(CardTypeConstant.BLACKLIST);
    }

    public static CardTypeDto ofNonVehicle() {
        return new CardTypeDto(CardTypeConstant.NON_VEHICLE);
    }
}
