package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

public interface ParkingExceptionConstant {

    String ERROR_PLATE_NUM1 = PlateNumConsts.NONE_PLATE;
    String ERROR_PLATE_NUM2 = PlateNumConsts.UNIDENTIFIED;
    String ERROR_PLATE_NUM3 = "unknow";
    String ERROR_PLATE_NUM4 = "unknown";

    /** 告警来源-系统平台 */
    int SOURCE_SYSTEM_VAL = 0;
    /** 告警来源-高位视频 */
    int SOURCE_HIGH_VIDEO_VAL = 1;
    /** 告警来源-高位视频 */
    int SOURCE_DICT_VAL = 2;
    /** 告警来源-POS机 */
    int SOURCE_POS_VAL = 3;
    /** 告警来源-人工 */
    int SOURCE_MANUAL_VAL = 4;
    /** 告警来源-巡检车 */
    int SOURCE_INSPECTION_VAL = 5;
    /** 告警来源-低位视频桩 */
    int SOURCE_VIDEO_PILE_VAL = 6;

    /** 告警来源-系统平台 */
    Integer SOURCE_SYSTEM = SOURCE_SYSTEM_VAL;
    /** 告警来源-高位视频 */
    Integer SOURCE_HIGH_VIDEO = SOURCE_HIGH_VIDEO_VAL;
    /** 告警来源-高位视频 */
    Integer SOURCE_DICT = SOURCE_DICT_VAL;
    /** 告警来源-POS机 */
    Integer SOURCE_POS = SOURCE_POS_VAL;
    /** 告警来源-人工 */
    Integer SOURCE_MANUAL = SOURCE_MANUAL_VAL;
    /** 告警来源-巡检车 */
    Integer SOURCE_INSPECTION = SOURCE_INSPECTION_VAL;
    /** 告警来源-低位视频桩 */
    Integer SOURCE_VIDEO_PILE = SOURCE_VIDEO_PILE_VAL;

    /** 告警类型-压线 */
    int TYPE_OVERLINE_VAL = 1;
    /** 告警类型-跨位 */
    int TYPE_SPAN_BERTH_VAL = 2;
    /** 告警类型-逆向 */
    int TYPE_REVERSE_PARKING_VAL = 3;
    /** 泊位外违停 */
    int TYPE_ILLEGAL_PARKING_VAL = 4;
    /** 限时违停 */
    int TYPE_ILLEGAL_PARKING_TIMEOUT_VAL = 5;

    /** 告警类型-压线 */
    Integer TYPE_OVERLINE = TYPE_OVERLINE_VAL;
    /** 告警类型-跨位 */
    Integer TYPE_SPAN_BERTH = TYPE_SPAN_BERTH_VAL;
    /** 告警类型-逆向 */
    Integer TYPE_REVERSE_PARKING = TYPE_REVERSE_PARKING_VAL;
    /** 泊位外违停 */
    Integer TYPE_ILLEGAL_PARKING = TYPE_ILLEGAL_PARKING_VAL;
    /** 限时违停 */
    Integer TYPE_ILLEGAL_PARKING_TIMEOUT = TYPE_ILLEGAL_PARKING_TIMEOUT_VAL;

    String REASON_OVERLINE = "车辆压线";
    String REASON_SPAN_BERTH = "车辆跨位";
    String REASON_REVERSE_PARKING = "车辆逆向停放";

    String REASON_ILLEGAL_PARKING = "车辆违法停车";
    String REASON_ILLEGAL_OVERTIME = "车辆超时违停";
    String REASON_ILLEGAL_OVER_INTERVAL = "车辆违法时间段停车";

    Map<Integer, String> ALARM_TYPE_REASON = new HashMap<Integer, String>() {{
        put(TYPE_OVERLINE_VAL, REASON_OVERLINE);
        put(TYPE_SPAN_BERTH_VAL, REASON_SPAN_BERTH);
        put(TYPE_REVERSE_PARKING_VAL, REASON_REVERSE_PARKING);
        put(TYPE_ILLEGAL_PARKING_VAL, REASON_ILLEGAL_PARKING);
        put(TYPE_ILLEGAL_PARKING_TIMEOUT_VAL, REASON_ILLEGAL_OVER_INTERVAL);
    }};
}
