package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 车辆类型
 * @author wangzhiwei
 */
public interface MonthCardStatusConstant {
    /** 生效中 */
    Integer USING = 1;
    /** 待生效 */
    Integer WAIT = 2;
    /** 已退费 */
    Integer REFUND = 3;
    /** 已过期 */
    Integer EXPIRE = 4;
    /** 冻结 */
    Integer FREEZE = 5;
    /** 暂停 */
    Integer STOP = 5;

    Map<Integer, String> map = new HashMap<Integer, String>() {{
        put(USING, "生效中");
        put(WAIT, "待生效");
        put(REFUND, "已退费");
        put(EXPIRE, "已过期");
        put(FREEZE, "冻结");
        put(STOP, "暂停");
    }};
    static String desc(Integer orderStatus){
        return map.get(orderStatus);
    }
}
