package com.icetech.city.road.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;

import org.apache.commons.lang3.StringUtils;

public class NumberUtils extends org.apache.commons.lang3.math.NumberUtils {
    public static final BigDecimal DECIMAL_HUNDRED = new BigDecimal(100);

    public static int toPrimitive(Integer value) {
        return toPrimitive(value, 0);
    }

    public static int toPrimitive(Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static long toPrimitive(Long value) {
        return toPrimitive(value, 0);
    }

    public static long toPrimitive(Long value, long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static float toPrimitive(Float value) {
        return value == null ? 0 : value;
    }

    public static double toPrimitive(Double value) {
        return value == null ? 0 : value;
    }

    /**
     * 转换浮点型，无需关心是否为空
     *
     * @param value
     * @return
     */
    public static float parseFloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        String content = value.toString();
        if (StringUtils.isBlank(content)) {
            return 0.0f;
        }
        return Float.parseFloat(content);
    }

    /**
     * 转换浮点型，无需关心是否为空
     *
     * @param value
     * @param pattern
     * @return
     */
    public static float parseFloat(Object value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return parseFloat(format.format(parseFloat(value)));
    }

    /**
     * 转换双精度型，无需关心是否为空
     *
     * @param value
     * @return
     */
    public static double parseDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        String content = value.toString();
        if (StringUtils.isBlank(content)) {
            return 0.0;
        }
        return Double.parseDouble(content);
    }

    /**
     * 转换双精度型，无需关心是否为空
     *
     * @param value
     * @return pattern
     */
    public static double parseDouble(Object value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return parseDouble(format.format(parseDouble(value)));
    }

    /**
     * 转换字符型，无需关心是否为空
     *
     * @param value
     * @param pattern
     * @return
     */
    public static String parseString(Object value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(parseDouble(value));
    }

    public static BigDecimal decimalDivideScale(int scale, RoundingMode mode, Object num, Object... nums) {
        return decimalCalculate((decimal1, decimal2) -> {
            return decimal1.divide(decimal2, scale, mode);
        }, num, nums);
    }

    private static BigDecimal decimalCalculate(DecimalCalculation calculation, Object num, Object... nums) {
        BigDecimal decimal = parseDecimal(num, BigDecimal.ZERO);
        if (nums != null && nums.length != 0) {
            for(int i = 0; i < nums.length; ++i) {
                BigDecimal middle = parseDecimal(nums[i], (BigDecimal)null);
                if (middle != null) {
                    decimal = calculation.calculate(decimal, middle);
                }
            }

            return decimal;
        } else {
            return decimal;
        }
    }
    private interface DecimalCalculation {
        BigDecimal calculate(BigDecimal var1, BigDecimal var2);
    }

    public static BigDecimal parseDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        } else if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        } else if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        } else if (value instanceof Float) {
            return new BigDecimal(Float.toString((Float)value));
        } else if (value instanceof Long) {
            return new BigDecimal((Long)value);
        } else if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        } else if (value instanceof Short) {
            return new BigDecimal((Short)value);
        } else {
            String middle = value.toString().trim();
            return middle.isEmpty() ? defaultValue : new BigDecimal(middle);
        }
    }

    public static BigDecimal decimalSubtract(Object num, Object... nums) {
        return decimalCalculate(BigDecimal::subtract, num, nums);
    }

    public static BigDecimal decimalAdd(Object num, Object... nums) {
        return decimalCalculate(BigDecimal::add, num, nums);
    }

    public static <T extends Comparable<T>> T min(T t1, T t2) {
        return t1.compareTo(t2) <= 0 ? t1 : t2;
    }

    public static <T extends Comparable<T>> T max(T t1, T t2) {
        return t1.compareTo(t2) >= 0 ? t1 : t2;
    }

    /**
     * 数字+小写字母+大写字母, 去除 <code>olOI</code>
     */
    public static char[] RADIX_58 = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz".toCharArray();
    /**
     * 数字+小写字母+大写字母, 去除 <code>lOI</code>
     */
    public static char[] RADIX_59 = "0123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();
    /**
     * 数字+小写字母+大写字母
     */
    public static char[] RADIX_62 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String radix59(BigInteger value) {
        return radix(value, RADIX_59);
    }

    public static String radix62(BigInteger value) {
        return radix(value, RADIX_62);
    }

    public static String radix(BigInteger value, char[] chars) {
        StringBuilder builder = new StringBuilder();
        BigInteger divider = BigInteger.valueOf(chars.length);
        do {
            BigInteger[] values = value.divideAndRemainder(divider);
            builder.append(chars[values[1].intValue()]);
            value = values[0];
        } while (value.compareTo(BigInteger.ZERO) > 0);

        return builder.reverse().toString();
    }

    public static BigInteger radixOf(String value, char[] chars) {
        BigInteger result = BigInteger.ZERO;
        char[] values = value.toCharArray();
        int valueLength = values.length;
        BigInteger radix = BigInteger.valueOf(chars.length);
        for (int index = 0, r = valueLength - 1; index < valueLength; index++, r--) {
            char val = values[r];
            for (int i = 0; i < chars.length; i++) {
                if (chars[i] == val) {
                    BigInteger step = radix.pow(index).multiply(new BigInteger(String.valueOf(i)));
                    result = result.add(step);
                    break;
                }
            }
        }

        return result;
    }
}
