package com.icetech.city.road.domain.table.plate.appeal;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 车牌申诉
 */
@Data
@Accessors(chain = true)
@TableName("ice_mp_appeal_plate")
public class MpAppealPlate implements Serializable {
    /** ID */
    @TableId(value = "`id`", type = IdType.AUTO)
    protected Long id;
    /** 微信用户ID */
    @TableField("`user_id`")
    protected Long userId;
    /** 申诉车牌号 */
    @TableField("`plate_num`")
    protected String plateNum;
    /** 车牌颜色 */
    @TableField("`plate_color`")
    protected Integer plateColor;
    /** 驾驶证 */
    @TableField("`driver_license_image`")
    protected String driverLicenseImage;
    /** 行驶证 */
    @TableField("`vehicle_license_image`")
    protected String vehicleLicenseImage;
    /** 备注 */
    @TableField("`remark`")
    protected String remark;
    /** 申诉状态 */
    @TableField("`appeal_status`")
    protected Integer appealStatus;
    /** 拒绝原因 */
    @TableField("`reject_reason`")
    protected String rejectReason;
    /** 创建时间 */
    @TableField("`create_time`")
    protected Date createTime;
    /** 审核人ID */
    @TableField("`check_user`")
    protected Long checkUser;
    /** 审核时间 */
    @TableField("`check_time`")
    protected Date checkTime;
}
